/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.core.Controller;
import io.jpress.core.JBaseController;
import io.jpress.interceptor.InterUtils;
import io.jpress.model.User;
import io.jpress.utils.EncryptUtils;
import java.math.BigInteger;

public class UCodeInterceptor
implements Interceptor {
    public void intercept(Invocation inv) {
        String ucode;
        if (this.isMultipartRequest(inv)) {
            inv.getController().getFile();
        }
        if ((ucode = inv.getController().getPara("ucode")) == null || "".equals(ucode.trim())) {
            this.renderError(inv);
            return;
        }
        User user = InterUtils.tryToGetUser((Invocation)inv);
        if (user == null) {
            this.renderError(inv);
            return;
        }
        if (!ucode.equals(EncryptUtils.generateUcode((BigInteger)user.getId(), (String)user.getSalt()))) {
            this.renderError(inv);
            return;
        }
        inv.invoke();
    }

    private boolean isMultipartRequest(Invocation inv) {
        String contentType = inv.getController().getRequest().getContentType();
        return contentType != null && contentType.toLowerCase().indexOf("multipart") != -1;
    }

    private void renderError(Invocation inv) {
        Controller c = inv.getController();
        if (c instanceof JBaseController) {
            ((JBaseController)c).renderAjaxResultForError("\u975e\u6cd5\u63d0\u4ea4");
        } else {
            c.renderError(404);
        }
    }
}

