/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.listener;

import io.jpress.menu.MenuGroup;
import io.jpress.menu.MenuItem;
import io.jpress.menu.MenuManager;
import io.jpress.message.Message;
import io.jpress.message.MessageListener;
import io.jpress.message.annotation.Listener;
import io.jpress.template.Template;
import io.jpress.template.TemplateManager;
import io.jpress.template.TplModule;
import io.jpress.template.TplTaxonomyType;
import io.jpress.utils.StringUtils;
import java.util.List;

@Listener(action={"_INIT_MENU"}, async=false)
public class AdminMenuInitListener
implements MessageListener {
    public void onMessage(Message message) {
        Object temp = message.getData();
        if (temp == null && !(temp instanceof MenuManager)) {
            return;
        }
        MenuManager menuMnager = (MenuManager)temp;
        this.initModuleMenuGroup(menuMnager);
        menuMnager.addMenuGroup(this.createAttachmentMenuGroup());
        menuMnager.addMenuGroup(this.createWechatMenuGroup());
        menuMnager.addMenuGroup(MenuGroup.createBlockGroup());
        menuMnager.addMenuGroup(this.createUserMenuGroup());
        menuMnager.addMenuGroup(this.createTemplateMenuGroup());
        menuMnager.addMenuGroup(this.createAddonMenuGroup());
        menuMnager.addMenuGroup(this.createSettingMenuGroup());
        menuMnager.addMenuGroup(this.createToolsMenuGroup());
    }

    public void initModuleMenuGroup(MenuManager menuMnager) {
        Template t = TemplateManager.me().currentTemplate();
        if (t == null || t.getModules() == null) {
            return;
        }
        List modules = t.getModules();
        for (TplModule module : modules) {
            String iconClass = module.getIconClass();
            if (StringUtils.isBlank((String)iconClass)) {
                iconClass = "fa fa-file-text-o";
            }
            MenuGroup group = new MenuGroup(module.getName(), iconClass, module.getTitle());
            group.addMenuItem(new MenuItem("list", "/admin/content?m=" + module.getName(), module.getListTitle()));
            group.addMenuItem(new MenuItem("edit", "/admin/content/edit?m=" + module.getName(), module.getAddTitle()));
            List types = module.getTaxonomyTypes();
            if (types != null && !types.isEmpty()) {
                for (TplTaxonomyType type : types) {
                    group.addMenuItem(new MenuItem(type.getName(), "/admin/taxonomy?m=" + module.getName() + "&t=" + type.getName(), type.getTitle()));
                }
            }
            if (StringUtils.isNotBlank((String)module.getCommentTitle())) {
                group.addMenuItem(new MenuItem("comment", "/admin/comment?t=comment&m=" + module.getName(), module.getCommentTitle()));
            }
            menuMnager.addMenuGroup(group);
        }
    }

    private MenuGroup createWechatMenuGroup() {
        MenuGroup group = new MenuGroup("wechat", "fa fa-weixin", "\u5fae\u4fe1");
        group.addMenuItem(new MenuItem("r", "/admin/wechat", "\u81ea\u52a8\u56de\u590d"));
        group.addMenuItem(new MenuItem("rd", "/admin/wechat/reply_default", "\u9ed8\u8ba4\u56de\u590d"));
        group.addMenuItem(new MenuItem("menu", "/admin/wechat/menu", "\u83dc\u5355\u8bbe\u7f6e"));
        group.addMenuItem(new MenuItem("option", "/admin/wechat/option", "\u5fae\u4fe1\u8bbe\u7f6e"));
        return group;
    }

    private MenuGroup createAttachmentMenuGroup() {
        MenuGroup group = new MenuGroup("attachment", "fa fa-file-image-o", "\u9644\u4ef6");
        group.addMenuItem(new MenuItem("list", "/admin/attachment", "\u6240\u6709\u9644\u4ef6"));
        group.addMenuItem(new MenuItem("upload", "/admin/attachment/upload", "\u4e0a\u4f20"));
        return group;
    }

    private MenuGroup createUserMenuGroup() {
        MenuGroup group = new MenuGroup("user", "fa fa-user", "\u7528\u6237");
        group.addMenuItem(new MenuItem("list", "/admin/user", "\u6240\u6709\u7528\u6237"));
        group.addMenuItem(new MenuItem("edit", "/admin/user/edit", "\u6dfb\u52a0"));
        group.addMenuItem(new MenuItem("info", "/admin/user/info", "\u6211\u7684\u8d44\u6599"));
        return group;
    }

    private MenuGroup createTemplateMenuGroup() {
        MenuGroup group = new MenuGroup("template", "fa fa-magic", "\u6a21\u677f");
        group.addMenuItem(new MenuItem("list", "/admin/template", "\u6240\u6709\u6a21\u677f"));
        group.addMenuItem(new MenuItem("install", "/admin/template/install", "\u6a21\u677f\u5b89\u88c5"));
        group.addMenuItem(new MenuItem("menu", "/admin/template/menu", "\u83dc\u5355"));
        group.addMenuItem(new MenuItem("setting", "/admin/template/setting", "\u8bbe\u7f6e"));
        group.addMenuItem(new MenuItem("edit", "/admin/template/edit", "\u7f16\u8f91"));
        return group;
    }

    private MenuGroup createAddonMenuGroup() {
        MenuGroup group = new MenuGroup("addon", "fa fa-plug", "\u63d2\u4ef6");
        group.addMenuItem(new MenuItem("list", "/admin/addon", "\u6240\u6709\u63d2\u4ef6"));
        group.addMenuItem(new MenuItem("install", "/admin/addon/install", "\u5b89\u88c5"));
        return group;
    }

    private MenuGroup createSettingMenuGroup() {
        MenuGroup group = new MenuGroup("option", "fa fa-cog", "\u8bbe\u7f6e");
        group.addMenuItem(new MenuItem("list", "/admin/option/web", "\u5e38\u89c4"));
        group.addMenuItem(new MenuItem("edit", "/admin/option/comment", "\u8bc4\u8bba"));
        group.addMenuItem(new MenuItem("n", "/admin/option/notification", "\u901a\u77e5"));
        group.addMenuItem(new MenuItem("seo", "/admin/option/seo", "SEO"));
        group.addMenuItem(new MenuItem("watermark", "/admin/option/watermark", "\u6c34\u5370"));
        group.addMenuItem(new MenuItem("url", "/admin/option/url", "\u8fde\u63a5\u5f62\u5f0f"));
        group.addMenuItem(new MenuItem("reg", "/admin/option/register", "\u767b\u5f55\u6ce8\u518c"));
        group.addMenuItem(new MenuItem("cdn", "/admin/option/cdn", "CDN\u52a0\u901f"));
        group.addMenuItem(new MenuItem("api", "/admin/api", "API\u5e94\u7528"));
        return group;
    }

    private MenuGroup createToolsMenuGroup() {
        MenuGroup group = new MenuGroup("tools", "fa fa-wrench", "\u5de5\u5177");
        group.addMenuItem(new MenuItem("import", "/admin/tools/_import", "\u5bfc\u5165"));
        group.addMenuItem(new MenuItem("export", "/admin/tools/export", "\u5bfc\u51fa"));
        group.addMenuItem(new MenuItem("sync", "/admin/tools/sync", "\u540c\u6b65"));
        return group;
    }
}

