/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.listener;

import com.jfinal.core.JFinal;
import io.jpress.message.Message;
import io.jpress.message.MessageListener;
import io.jpress.message.annotation.Listener;
import io.jpress.model.Comment;
import io.jpress.model.Content;
import io.jpress.model.User;
import io.jpress.model.query.OptionQuery;
import io.jpress.model.query.UserQuery;
import io.jpress.notify.email.Email;
import io.jpress.notify.email.EmailSenderFactory;
import io.jpress.utils.StringUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
@Listener(action={"content:add", "comment:add"})
public class AtProcessListener
implements MessageListener {
    static Pattern userPattern = Pattern.compile("@([^@^\\s^:]{1,})([\\s\\:\\,\\;]{0,1})");

    public void onMessage(Message message) {
        ArrayList userIds = new ArrayList();
        if ("content:add".equals(message.getAction())) {
            Content content = (Content)message.getData();
            String text = AtProcessListener.generateUserLinks((String)content.getText(), userIds);
            content.setText(text);
            content.update();
        } else if ("comment:add".equals(message.getAction())) {
            Comment comment = (Comment)message.getData();
            String text = AtProcessListener.generateUserLinks((String)comment.getText(), userIds);
            comment.setText(text);
            comment.update();
        }
        this.notifyUser(userIds);
    }

    private void notifyUser(List<BigInteger> userIds) {
        if (userIds != null && userIds.size() > 0) {
            for (BigInteger userId : userIds) {
                this.notifyByEmail(userId);
            }
        }
    }

    private void notifyByEmail(BigInteger id) {
        Boolean notify = OptionQuery.me().findValueAsBool("notify_author_by_email_when_at");
        if (notify != null && notify.booleanValue()) {
            User user = UserQuery.me().findById(id);
            if (user == null || user.getEmail() == null) {
                return;
            }
            Email email = new Email();
            email.subject("\u6709\u4eba@\u4f60\u4e86....");
            String content = OptionQuery.me().findValue("notify_author_content_by_email_when_at");
            if (StringUtils.isBlank((String)content)) {
                content = "\u6709\u4eba@\u4f60\u4e86....";
            }
            email.content(content);
            email.to(new String[]{user.getEmail()});
            EmailSenderFactory.createSender().send(email);
        }
    }

    public static String generateUserLinks(String msg, List<BigInteger> userIds) {
        StringBuilder html = new StringBuilder();
        int lastIdx = 0;
        Matcher matchr = userPattern.matcher(msg);
        while (matchr.find()) {
            String groupString = matchr.group();
            String username = groupString.substring(1, groupString.length()).trim();
            html.append(msg.substring(lastIdx, matchr.start()));
            User user = UserQuery.me().findUserByUsername(username);
            if (user != null && !user.isFrozen()) {
                String userUrl = JFinal.me().getContextPath() + user.getUrl();
                html.append("<a href=\"" + userUrl + "\" class='referer' target='_blank'>@");
                html.append(username.trim());
                html.append("</a> ");
                if (userIds != null && !userIds.contains(user.getId())) {
                    userIds.add(user.getId());
                }
            } else {
                html.append(groupString);
            }
            lastIdx = matchr.end();
        }
        html.append(msg.substring(lastIdx));
        return html.toString();
    }
}

