/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.listener;

import io.jpress.message.Message;
import io.jpress.message.MessageListener;
import io.jpress.message.annotation.Listener;
import io.jpress.model.Comment;
import io.jpress.model.Content;
import io.jpress.model.User;
import io.jpress.model.query.CommentQuery;
import io.jpress.model.query.ContentQuery;
import io.jpress.model.query.OptionQuery;
import io.jpress.model.query.UserQuery;
import io.jpress.notify.email.Email;
import io.jpress.notify.email.EmailSenderFactory;
import io.jpress.utils.DateUtils;
import io.jpress.utils.StringUtils;
import java.math.BigInteger;
import java.util.Date;

@Listener(action={"comment:add"})
public class AuthorNotificationListener
implements MessageListener {
    public void onMessage(Message message) {
        if ("comment:add".equals(message.getAction())) {
            this.notify(message);
        }
    }

    private void notify(Message message) {
        Content content;
        Object temp = message.getData();
        if (temp == null && !(temp instanceof Comment)) {
            return;
        }
        Comment comment = (Comment)temp;
        if (Comment.STATUS_NORMAL.equals(comment.getStatus()) && comment.getContentId() != null && (content = ContentQuery.me().findById(comment.getContentId())) != null) {
            BigInteger authorId = content.getUserId();
            this.notifyAuthorByEmail(authorId, comment);
            this.notifyParentCommentAuthorByEmail(comment);
        }
    }

    private void notifyAuthorByEmail(BigInteger id, Comment comment) {
        Boolean notify = OptionQuery.me().findValueAsBool("notify_author_by_email_when_has_comment");
        if (notify != null && notify.booleanValue()) {
            User user = UserQuery.me().findById(id);
            if (user == null || user.getEmail() == null) {
                return;
            }
            String webname = OptionQuery.me().findValue("web_name");
            webname = StringUtils.isBlank((String)webname) ? "" : webname;
            String webdomain = OptionQuery.me().findValue("web_domain");
            Email email = new Email();
            email.subject("\u6709\u4eba\u5728 [" + webname + "] \u8bc4\u8bba\u4e86\u60a8\u7684\u6587\u7ae0\uff01");
            String content = OptionQuery.me().findValue("notify_author_content_by_email_when_has_comment");
            if (StringUtils.isBlank((String)content)) {
                String url = webdomain + comment.getContentUrl();
                content = "\u6709\u4eba\u5728 [" + webname + "] \u8bc4\u8bba\u4e86\u60a8\u7684\u6587\u7ae0\u3002<br />\u8bc4\u8bba\u5185\u5bb9\u662f\uff1a" + comment.getText() + "<br />\u8be6\u60c5\uff1a<a href=\"" + url + "\">" + url + "</a>";
            } else {
                content = this.replaceContent(comment, webdomain, content);
            }
            email.content(content);
            email.to(new String[]{user.getEmail()});
            EmailSenderFactory.createSender().send(email);
        }
    }

    private void notifyParentCommentAuthorByEmail(Comment comment) {
        Boolean notify = OptionQuery.me().findValueAsBool("notify_parent_author_by_email_when_has_comment");
        if (notify != null && notify.booleanValue()) {
            BigInteger parentCommentId = comment.getParentId();
            if (parentCommentId == null) {
                return;
            }
            Comment parentComment = CommentQuery.me().findById((Object)parentCommentId);
            if (parentComment == null) {
                return;
            }
            User user = UserQuery.me().findById(parentComment.getUserId());
            if (user == null || user.getEmail() == null) {
                return;
            }
            String webname = OptionQuery.me().findValue("web_name");
            webname = StringUtils.isBlank((String)webname) ? "" : webname;
            String webdomain = OptionQuery.me().findValue("web_domain");
            Email email = new Email();
            email.subject("\u6709\u4eba\u5728 [" + webname + "] \u56de\u590d\u4e86\u60a8\u7684\u8bc4\u8bba\uff01");
            String content = OptionQuery.me().findValue("notify_parent_author_content_by_email_when_has_comment");
            if (StringUtils.isBlank((String)content)) {
                String url = webdomain + comment.getContentUrl();
                content = "\u6709\u4eba\u5728 [" + webname + "] \u56de\u590d\u4e86\u60a8\u7684\u8bc4\u8bba\u3002<br />\u56de\u590d\u5185\u5bb9\u662f\uff1a" + comment.getText() + "<br />\u8be6\u60c5\uff1a<a href=\"" + url + "\">" + url + "</a>";
            } else {
                content = this.replaceContent(comment, webdomain, content);
            }
            email.content(content);
            email.to(new String[]{user.getEmail()});
            EmailSenderFactory.createSender().send(email);
        }
    }

    private String replaceContent(Comment comment, String webdomain, String content) {
        if (StringUtils.isNotBlank((String)comment.getText())) {
            content = content.replace("${comment.text}", comment.getText());
        }
        if (StringUtils.isNotBlank((String)comment.getAuthor())) {
            content = content.replace("${comment.author}", comment.getAuthor());
        }
        if (StringUtils.isNotBlank((String)comment.getEmail())) {
            content = content.replace("${comment.email}", comment.getEmail());
        }
        if (StringUtils.isNotBlank((String)comment.getContentUrl())) {
            content = content.replace("${comment.contentUrl}", webdomain + comment.getContentUrl());
        }
        if (StringUtils.isNotBlank((String)comment.getcontentTitle())) {
            content = content.replace("${comment.contentTitle}", comment.getcontentTitle());
        }
        if (StringUtils.isNotBlank((String)comment.getUsername())) {
            content = content.replace("${comment.username}", comment.getUsername());
        }
        if (comment.getCreated() != null) {
            content = content.replace("${comment.created}", DateUtils.format((Date)comment.getCreated()));
        }
        return content;
    }
}

