/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.listener;

import io.jpress.message.Message;
import io.jpress.message.MessageListener;
import io.jpress.message.annotation.Listener;
import io.jpress.model.Content;
import io.jpress.model.Taxonomy;
import io.jpress.model.query.ContentQuery;
import io.jpress.model.query.TaxonomyQuery;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

@Listener(action={"system:setting_changed"})
public class MenuChangedListener
implements MessageListener {
    public void onMessage(Message message) {
        Map datas;
        Object temp = message.getData();
        if (temp != null && temp instanceof Map && ((datas = (Map)temp).containsKey("router_content_type") || datas.containsKey("router_fakestatic_enable"))) {
            this.updateMenus();
        }
    }

    private void updateMenus() {
        List list = ContentQuery.me().findByModule("menu", null, "order_number ASC");
        if (list != null && list.size() > 0) {
            for (Content content : list) {
                Taxonomy taxonomy;
                BigInteger taxonomyId = content.getObjectId();
                if (taxonomyId == null || (taxonomy = TaxonomyQuery.me().findById(taxonomyId)) == null) continue;
                content.setText(taxonomy.getUrl());
                content.saveOrUpdate();
            }
        }
    }
}

