/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.listener;

import io.jpress.message.Message;
import io.jpress.message.MessageListener;
import io.jpress.message.annotation.Listener;
import io.jpress.model.Comment;
import io.jpress.model.User;
import io.jpress.model.query.UserQuery;

@Listener(action={"comment:add", "comment:update", "comment:delete"})
public class UserCommentCountUpdateListener
implements MessageListener {
    public void onMessage(Message message) {
        if ("comment:add".equals(message.getAction())) {
            this.updateUserCommentCount(message);
        } else if ("comment:update".equals(message.getAction())) {
            this.updateUserCommentCount(message);
        } else if ("comment:delete".equals(message.getAction())) {
            this.updateUserCommentCount(message);
        }
    }

    private void updateUserCommentCount(Message message) {
        User user;
        Comment comment;
        Object temp = message.getData();
        if (temp != null && temp instanceof Comment && Comment.STATUS_NORMAL.equals((comment = (Comment)temp).getStatus()) && comment.getUserId() != null && (user = UserQuery.me().findById(comment.getUserId())) != null) {
            UserQuery.me().updateCommentCount(user);
        }
    }
}

