/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.listener;

import io.jpress.message.Message;
import io.jpress.message.MessageListener;
import io.jpress.message.annotation.Listener;
import io.jpress.model.Content;
import io.jpress.model.User;
import io.jpress.model.query.UserQuery;

@Listener(action={"content:add", "content:update", "content:delete"})
public class UserContentCountChangedListener
implements MessageListener {
    public void onMessage(Message message) {
        if ("content:add".equals(message.getAction())) {
            this.updateUserConentCount(message);
        } else if ("content:update".equals(message.getAction())) {
            this.updateUserConentCount(message);
        } else if ("content:delete".equals(message.getAction())) {
            this.updateUserConentCount(message);
        }
    }

    private void updateUserConentCount(Message message) {
        User user;
        Content content;
        Object temp = message.getData();
        if (temp != null && temp instanceof Content && Content.STATUS_NORMAL.equals((content = (Content)temp).getStatus()) && content.getUserId() != null && (user = UserQuery.me().findById(content.getUserId())) != null) {
            UserQuery.me().updateContentCount(user);
        }
    }
}

