/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.router;

import com.jfinal.core.JFinal;
import io.jpress.model.query.OptionQuery;
import io.jpress.utils.StringUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class RouterConverter {
    public static final String URL_PARA_SEPARATOR = JFinal.me().getConstants().getUrlParaSeparator();
    public static final String SLASH = "/";

    public abstract String converter(String var1, HttpServletRequest var2, HttpServletResponse var3);

    public static BigInteger tryGetBigInteger(String param) {
        try {
            return new BigInteger(param);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String[] parseTarget(String target) {
        String[] strings = target.split(SLASH);
        ArrayList<String> arrays = new ArrayList<String>();
        for (String string : strings) {
            if (!StringUtils.isNotBlank((String)string)) continue;
            arrays.add(string);
        }
        return arrays.toArray(new String[0]);
    }

    public static String[] parseParam(String param) {
        String[] strings = param.split(URL_PARA_SEPARATOR);
        ArrayList<String> arrays = new ArrayList<String>();
        for (String string : strings) {
            if (!StringUtils.isNotBlank((String)string)) continue;
            arrays.add(string);
        }
        return arrays.toArray(new String[0]);
    }

    protected static boolean enalbleFakeStatic() {
        Boolean fakeStaticEnable = OptionQuery.me().findValueAsBool("router_fakestatic_enable");
        return fakeStaticEnable != null && fakeStaticEnable == true;
    }

    protected static String getFakeStaticSuffix() {
        String fakeStaticSuffix = OptionQuery.me().findValue("router_fakestatic_suffix");
        if (StringUtils.isBlank((String)fakeStaticSuffix)) {
            fakeStaticSuffix = ".html";
        }
        return fakeStaticSuffix.trim();
    }
}

