/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.router.converter;

import io.jpress.model.query.OptionQuery;
import io.jpress.router.RouterConverter;
import io.jpress.template.TemplateManager;
import io.jpress.template.TplModule;
import io.jpress.utils.DateUtils;
import io.jpress.utils.StringUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * Exception performing whole class analysis ignored.
 */
public class ContentRouter
extends RouterConverter {
    public static final String TYPE_STATIC_MODULE_SLUG = "_static_module_slug";
    public static final String TYPE_STATIC_MODULE_ID = "_static_module_id";
    public static final String TYPE_STATIC_DATE_SLUG = "_static_date_slug";
    public static final String TYPE_STATIC_DATE_ID = "_static_date_id";
    public static final String TYPE_STATIC_PREFIX_SLUG = "_static_prefix_slug";
    public static final String TYPE_STATIC_PREFIX_ID = "_static_prefix_id";
    public static final String TYPE_DYNAMIC_ID = "_dynamic_id";
    public static final String TYPE_DYNAMIC_SLUG = "_dynamic_slug";
    public static final String DEFAULT_TYPE = "_static_prefix_slug";

    public String converter(String target, HttpServletRequest request, HttpServletResponse response) {
        String[] targetDirs = ContentRouter.parseTarget((String)target);
        if (targetDirs == null || targetDirs.length == 0) {
            return null;
        }
        if (targetDirs != null && targetDirs.length == 1) {
            String settingType = ContentRouter.getRouterType();
            if ("_dynamic_id".equals(settingType) || "_dynamic_slug".equals(settingType)) {
                String prefix = ContentRouter.getRouterPrefix();
                return prefix.equals(targetDirs[0]) ? "/c" : null;
            }
            return null;
        }
        String[] params = ContentRouter.parseParam((String)targetDirs[1]);
        if (params == null || params.length == 0) {
            return null;
        }
        String settingType = ContentRouter.getRouterType();
        if ("_static_module_slug".equals(settingType) || "_static_module_id".equals(settingType)) {
            TplModule m = TemplateManager.me().currentTemplateModule(targetDirs[0]);
            return m == null ? null : "/c/" + targetDirs[1];
        }
        if ("_static_date_slug".equals(settingType) || "_static_date_id".equals(settingType)) {
            try {
                Integer.valueOf(targetDirs[0]);
                return "/c/" + targetDirs[1];
            }
            catch (Exception e) {
                return null;
            }
        }
        if ("_static_prefix_slug".equals(settingType) || "_static_prefix_id".equals(settingType)) {
            String prefix = ContentRouter.getRouterPrefix();
            return prefix.equals(targetDirs[0]) ? "/c/" + targetDirs[1] : null;
        }
        return null;
    }

    public static String getRouterType() {
        String type = OptionQuery.me().findValue("router_content_type");
        if (StringUtils.isBlank((String)type)) {
            return "_static_prefix_slug";
        }
        return type;
    }

    public static String getRouterPrefix() {
        String prefix = OptionQuery.me().findValue("router_content_prefix");
        if (StringUtils.isBlank((String)prefix)) {
            prefix = "/c".substring(1);
        }
        return prefix;
    }

    public static String getContentRouterSuffix(TplModule module) {
        if ("page".equals(module.getName())) {
            if (ContentRouter.enalbleFakeStatic()) {
                return ContentRouter.getFakeStaticSuffix();
            }
            return "";
        }
        String routerType = ContentRouter.getRouterType();
        if ("_dynamic_id".equals(routerType) || "_dynamic_slug".equals(routerType)) {
            return "";
        }
        if (ContentRouter.enalbleFakeStatic()) {
            return ContentRouter.getFakeStaticSuffix();
        }
        return "";
    }

    public static String getContentRouterPreffix(TplModule module) {
        if ("page".equals(module.getName())) {
            return "/";
        }
        String urlPreffix = "";
        String routerType = ContentRouter.getRouterType();
        if ("_dynamic_id".equals(routerType)) {
            String router_content_prefix = ContentRouter.getRouterPrefix();
            urlPreffix = "/" + router_content_prefix + "?id=";
        } else if ("_dynamic_slug".equals(routerType)) {
            String router_content_prefix = ContentRouter.getRouterPrefix();
            urlPreffix = "/" + router_content_prefix + "?slug=";
        } else if ("_static_prefix_slug".equals(routerType)) {
            String router_content_prefix = ContentRouter.getRouterPrefix();
            urlPreffix = "/" + router_content_prefix + "/";
        } else if ("_static_date_slug".equals(routerType)) {
            String router_content_prefix = DateUtils.dateString();
            urlPreffix = "/" + router_content_prefix + "/";
        } else if ("_static_module_slug".equals(routerType)) {
            String router_content_prefix = module.getName();
            urlPreffix = "/" + router_content_prefix + "/";
        } else {
            String router_content_prefix = ContentRouter.getRouterPrefix();
            urlPreffix = "/" + router_content_prefix + "?id=";
        }
        return urlPreffix;
    }
}

