/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.ui.freemarker.function;

import io.jpress.core.render.freemarker.JFunction;
import io.jpress.model.Content;
import io.jpress.model.Taxonomy;
import io.jpress.model.query.TaxonomyQuery;
import io.jpress.template.TplTaxonomyType;
import java.util.List;

public class TaxonomyBox
extends JFunction {
    private TplTaxonomyType taxonomyType;
    private Content content;
    private List<Taxonomy> contentTaxonomyList;

    public Object onExec() {
        this.init();
        return this.doExec();
    }

    private void init() {
        this.taxonomyType = (TplTaxonomyType)this.get(0);
        this.content = (Content)this.get(1);
        this.contentTaxonomyList = this.content != null ? TaxonomyQuery.me().findListByContentId(this.content.getId()) : null;
    }

    private Object doExec() {
        String moduleName = this.taxonomyType.getModule().getName();
        String txType = this.taxonomyType.getName();
        List list = TaxonomyQuery.me().findListByModuleAndTypeAsTree(moduleName, txType);
        StringBuilder htmlBuilder = new StringBuilder();
        if (list != null && list.size() > 0) {
            this.doBuilder(list, htmlBuilder);
        }
        return htmlBuilder.toString();
    }

    private void doBuilder(List<Taxonomy> list, StringBuilder htmlBuilder) {
        htmlBuilder.append("<ul>");
        for (Taxonomy taxonomy : list) {
            boolean checked = this.contentTaxonomyList != null && this.contentTaxonomyList.contains(taxonomy);
            String html = "<li ><label><input  name=\"_%s\" value=\"%s\" %s type=\"checkbox\"/>%s</label></li>";
            htmlBuilder.append(String.format(html, this.taxonomyType.getName(), taxonomy.getId(), checked ? "checked=\"checked\"" : "", taxonomy.getTitle()));
            if (taxonomy.getChildList() == null || taxonomy.getChildList().size() <= 0) continue;
            this.doBuilder(taxonomy.getChildList(), htmlBuilder);
        }
        htmlBuilder.append("</ul>");
    }
}

