/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.ui.freemarker.tag;

import io.jpress.core.render.freemarker.JTag;
import io.jpress.model.ModelSorter;
import io.jpress.model.Taxonomy;
import io.jpress.model.query.ContentQuery;
import io.jpress.model.query.TaxonomyQuery;
import io.jpress.utils.StringUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class ContentsTag
extends JTag {
    public static final String TAG_NAME = "jp.contents";

    public void onRender() {
        List data;
        String orderBy = this.getParam("orderBy");
        String keyword = this.getParam("keyword");
        int pageNumber = this.getParamToInt("page", Integer.valueOf(1));
        int pageSize = this.getParamToInt("pageSize", Integer.valueOf(10));
        Integer count = this.getParamToInt("count");
        if (count != null && count > 0) {
            pageSize = count;
        }
        BigInteger[] typeIds = this.getParamToBigIntegerArray("typeId");
        String[] typeSlugs = this.getParamToStringArray("typeSlug");
        String[] tags = this.getParamToStringArray("tag");
        String[] modules = this.getParamToStringArray("module");
        String[] styles = this.getParamToStringArray("style");
        String[] flags = this.getParamToStringArray("flag");
        String[] slugs = this.getParamToStringArray("slug");
        BigInteger[] userIds = this.getParamToBigIntegerArray("userId");
        BigInteger[] parentIds = this.getParamToBigIntegerArray("parentId");
        Boolean hasThumbnail = this.getParamToBool("hasThumbnail");
        Taxonomy upperTaxonomy = null;
        if (modules != null && modules.length == 1) {
            String upperSlug;
            BigInteger upperId = this.getParamToBigInteger("upperId");
            if (upperId != null) {
                upperTaxonomy = TaxonomyQuery.me().findById(upperId);
            }
            if (upperTaxonomy == null && StringUtils.isNotBlank((String)(upperSlug = this.getParam("upperSlug")))) {
                upperTaxonomy = TaxonomyQuery.me().findBySlugAndModule(upperSlug, modules[0]);
            }
        }
        if (upperTaxonomy != null) {
            List list = TaxonomyQuery.me().findListByModuleAndType(modules[0], null);
            ArrayList newlist = new ArrayList();
            ModelSorter.sort((List)list, newlist, (BigInteger)upperTaxonomy.getId(), (int)0);
            if (newlist != null && newlist.size() > 0) {
                slugs = null;
                typeIds = new BigInteger[newlist.size() + 1];
                typeIds[0] = upperTaxonomy.getId();
                for (int i = 1; i < typeIds.length; ++i) {
                    typeIds[i] = ((Taxonomy)newlist.get(i - 1)).getId();
                }
            }
        }
        if ((data = ContentQuery.me().findListInNormal(pageNumber, pageSize, orderBy, keyword, typeIds, typeSlugs, modules, styles, flags, slugs, userIds, parentIds, tags, hasThumbnail, null)) == null || data.isEmpty()) {
            this.renderText("");
            return;
        }
        this.setVariable("contents", (Object)data);
        this.renderBody();
    }
}

