/*
 * Decompiled with CFR 0.152.
 */
package io.jpress.wechat;

import com.jfinal.aop.Before;
import com.jfinal.core.Controller;
import com.jfinal.kit.PropKit;
import com.jfinal.plugin.ehcache.CacheKit;
import com.jfinal.weixin.sdk.api.ApiConfig;
import com.jfinal.weixin.sdk.api.ApiResult;
import com.jfinal.weixin.sdk.jfinal.MsgController;
import com.jfinal.weixin.sdk.msg.in.InImageMsg;
import com.jfinal.weixin.sdk.msg.in.InLinkMsg;
import com.jfinal.weixin.sdk.msg.in.InLocationMsg;
import com.jfinal.weixin.sdk.msg.in.InMsg;
import com.jfinal.weixin.sdk.msg.in.InShortVideoMsg;
import com.jfinal.weixin.sdk.msg.in.InTextMsg;
import com.jfinal.weixin.sdk.msg.in.InVideoMsg;
import com.jfinal.weixin.sdk.msg.in.InVoiceMsg;
import com.jfinal.weixin.sdk.msg.in.event.InCustomEvent;
import com.jfinal.weixin.sdk.msg.in.event.InFollowEvent;
import com.jfinal.weixin.sdk.msg.in.event.InLocationEvent;
import com.jfinal.weixin.sdk.msg.in.event.InMassEvent;
import com.jfinal.weixin.sdk.msg.in.event.InMenuEvent;
import com.jfinal.weixin.sdk.msg.in.event.InPoiCheckNotifyEvent;
import com.jfinal.weixin.sdk.msg.in.event.InQrCodeEvent;
import com.jfinal.weixin.sdk.msg.in.event.InShakearoundUserShakeEvent;
import com.jfinal.weixin.sdk.msg.in.event.InTemplateMsgEvent;
import com.jfinal.weixin.sdk.msg.in.event.InVerifyFailEvent;
import com.jfinal.weixin.sdk.msg.in.event.InVerifySuccessEvent;
import com.jfinal.weixin.sdk.msg.in.speech_recognition.InSpeechRecognitionResults;
import com.jfinal.weixin.sdk.msg.out.News;
import com.jfinal.weixin.sdk.msg.out.OutCustomMsg;
import com.jfinal.weixin.sdk.msg.out.OutMsg;
import com.jfinal.weixin.sdk.msg.out.OutNewsMsg;
import com.jfinal.weixin.sdk.msg.out.OutTextMsg;
import io.jpress.model.Content;
import io.jpress.model.query.ContentQuery;
import io.jpress.model.query.OptionQuery;
import io.jpress.router.RouterMapping;
import io.jpress.template.TemplateManager;
import io.jpress.template.TplModule;
import io.jpress.utils.CookieUtils;
import io.jpress.utils.StringUtils;
import io.jpress.wechat.ProcesserManager;
import io.jpress.wechat.WechatApi;
import io.jpress.wechat.WechatApiConfigInterceptor;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
@RouterMapping(url="/wechat")
public class WechatMessageController
extends MsgController {
    public ApiConfig getApiConfig() {
        return WechatApi.getApiConfig();
    }

    @Before(value={WechatApiConfigInterceptor.class})
    public void callback() {
        String appSecret;
        String gotoUrl = this.getPara("goto");
        String code = this.getPara("code");
        String appId = PropKit.get((String)"wechat_app_id").trim();
        ApiResult result = WechatApi.getOpenId((String)appId, (String)(appSecret = PropKit.get((String)"wechat_app_secret").trim()), (String)code);
        if (result != null) {
            String openId = result.getStr("openid");
            CookieUtils.put((Controller)this, (String)"_wechat_openid", (String)openId);
            ApiResult ai = WechatApi.getUserInfo((String)openId);
            String nickname = ai.getStr("nickname");
            if (nickname != null) {
                nickname = StringUtils.urlEncode((String)nickname);
            }
            CookieUtils.put((Controller)this, (String)"_wechat_nickname", (String)nickname);
            String avator = ai.getStr("headimgurl");
            CookieUtils.put((Controller)this, (String)"_wechat_avatar", (String)avator);
        }
        this.redirect(gotoUrl);
    }

    protected void processInTextMsg(InTextMsg inTextMsg) {
        String text = inTextMsg.getContent();
        this.processTextReplay((InMsg)inTextMsg, text);
    }

    protected void processInMenuEvent(InMenuEvent inMenuEvent) {
        if ("CLICK".equals(inMenuEvent.getEvent())) {
            String text = inMenuEvent.getEventKey();
            this.processTextReplay((InMsg)inMenuEvent, text);
        } else {
            this.renderNull();
        }
    }

    protected void processInImageMsg(InImageMsg inImageMsg) {
        this.processDefaultReplay("wechat_processInImageMsg", (InMsg)inImageMsg);
    }

    protected void processInVoiceMsg(InVoiceMsg inVoiceMsg) {
        this.processDefaultReplay("wechat_processInVoiceMsg", (InMsg)inVoiceMsg);
    }

    protected void processInVideoMsg(InVideoMsg inVideoMsg) {
        this.processDefaultReplay("wechat_processInVideoMsg", (InMsg)inVideoMsg);
    }

    protected void processInShortVideoMsg(InShortVideoMsg inShortVideoMsg) {
        this.processDefaultReplay("wechat_processInVideoMsg", (InMsg)inShortVideoMsg);
    }

    protected void processInLocationMsg(InLocationMsg inLocationMsg) {
        this.processDefaultReplay("wechat_processInLocationMsg", (InMsg)inLocationMsg);
    }

    protected void processInLinkMsg(InLinkMsg inLinkMsg) {
        this.processDefaultReplay("wechat_processInLinkMsg", (InMsg)inLinkMsg);
    }

    protected void processInCustomEvent(InCustomEvent inCustomEvent) {
        if ("kf_close_session".equals(inCustomEvent.getEvent())) {
            // empty if block
        }
        this.processDefaultReplay("wechat_processInCustomEvent", (InMsg)inCustomEvent);
    }

    protected void processInFollowEvent(InFollowEvent inFollowEvent) {
        if ("subscribe".equals(inFollowEvent.getEvent())) {
            this.processDefaultReplay("wechat_processInFollowEvent", (InMsg)inFollowEvent);
        }
        if ("unsubscribe".equals(inFollowEvent.getEvent())) {
            // empty if block
        }
    }

    protected void processInQrCodeEvent(InQrCodeEvent inQrCodeEvent) {
        this.processDefaultReplay("wechat_processInQrCodeEvent", (InMsg)inQrCodeEvent);
    }

    protected void processInLocationEvent(InLocationEvent inLocationEvent) {
        this.processDefaultReplay("wechat_processInLocationEvent", (InMsg)inLocationEvent);
    }

    protected void processInMassEvent(InMassEvent inMassEvent) {
        this.processDefaultReplay("wechat_processInMassEvent", (InMsg)inMassEvent);
    }

    protected void processInSpeechRecognitionResults(InSpeechRecognitionResults inSpeechRecognitionResults) {
        this.processDefaultReplay("wechat_processInSpeechRecognitionResults", (InMsg)inSpeechRecognitionResults);
    }

    protected void processInTemplateMsgEvent(InTemplateMsgEvent inTemplateMsgEvent) {
        this.processDefaultReplay("wechat_processInTemplateMsgEvent", (InMsg)inTemplateMsgEvent);
    }

    protected void processInShakearoundUserShakeEvent(InShakearoundUserShakeEvent inShakearoundUserShakeEvent) {
        this.processDefaultReplay("wechat_processInShakearoundUserShakeEvent", (InMsg)inShakearoundUserShakeEvent);
    }

    protected void processInVerifySuccessEvent(InVerifySuccessEvent inVerifySuccessEvent) {
        this.processDefaultReplay("wechat_processInVerifySuccessEvent", (InMsg)inVerifySuccessEvent);
    }

    protected void processInVerifyFailEvent(InVerifyFailEvent inVerifyFailEvent) {
        this.processDefaultReplay("wechat_processInVerifyFailEvent", (InMsg)inVerifyFailEvent);
    }

    protected void processInPoiCheckNotifyEvent(InPoiCheckNotifyEvent inPoiCheckNotifyEvent) {
        this.processDefaultReplay("wechat_processInPoiCheckNotifyEvent", (InMsg)inPoiCheckNotifyEvent);
    }

    private void processTextReplay(InMsg message, String userInput) {
        if (this.dkfProcess(message, userInput)) {
            return;
        }
        Content content = ContentQuery.me().findFirstByModuleAndTitle("wechat_reply", userInput);
        if (content != null && StringUtils.isNotBlank((String)content.getText())) {
            this.textOrSeniorRender(message, content.getText());
            return;
        }
        if (this.searchProcess(message, userInput)) {
            return;
        }
        this.processDefaultReplay("wechat_search_no_matching", message);
    }

    private boolean searchProcess(InMsg message, String userInput) {
        List contents;
        List modules = TemplateManager.me().currentTemplateModules();
        if (StringUtils.isBlank((String)userInput) || modules == null || modules.size() == 0) {
            return false;
        }
        TplModule searchModule = null;
        TplModule nonePrefixModule = null;
        for (TplModule module : modules) {
            Boolean bool = OptionQuery.me().findValueAsBool(String.format("wechat_search_%s_enable", module.getName()));
            if (bool == null || !bool.booleanValue()) continue;
            String prefix = OptionQuery.me().findValue(String.format("wechat_search_%s_prefix", module.getName()));
            if (StringUtils.isBlank((String)prefix) && nonePrefixModule == null) {
                nonePrefixModule = module;
                continue;
            }
            if (!StringUtils.isNotBlank((String)prefix) || !userInput.startsWith(prefix)) continue;
            searchModule = module;
            userInput = userInput.substring(prefix.length());
            break;
        }
        if (searchModule == null) {
            searchModule = nonePrefixModule;
        }
        if (searchModule == null || StringUtils.isBlank((String)userInput)) {
            return false;
        }
        Integer count = OptionQuery.me().findValueAsInteger(String.format("wechat_search_%s_count", searchModule.getName()));
        if (count == null || count <= 0 || count > 10) {
            count = 10;
        }
        if ((contents = ContentQuery.me().searchByModuleAndTitle(searchModule.getName(), userInput, count.intValue())) == null || contents.isEmpty()) {
            this.processDefaultReplay("wechat_search_none_content", message);
            return true;
        }
        String domain = OptionQuery.me().findValue("web_domain");
        if (StringUtils.isBlank((String)domain)) {
            OutTextMsg otm = new OutTextMsg(message);
            otm.setContent("\u60a8\u8fd8\u6ca1\u6709\u914d\u7f6e\u60a8\u7684\u57df\u540d\uff0c\u8bf7\u5148\u5728\u540e\u53f0\u7684\u3010\u8bbe\u7f6e\u3011>\u3010\u5e38\u89c4\u3011\u91cc\u914d\u7f6e\u60a8\u7684\u7f51\u7ad9\u57df\u540d\uff01");
            this.render((OutMsg)otm);
            return true;
        }
        OutNewsMsg out = new OutNewsMsg(message);
        for (Content content : contents) {
            News news = new News();
            news.setTitle(content.getTitle());
            news.setDescription(content.getSummary());
            news.setPicUrl(domain + content.getImage());
            news.setUrl(domain + content.getUrl());
            out.addNews(news);
        }
        this.render((OutMsg)out);
        return true;
    }

    private boolean dkfProcess(InMsg message, String userInput) {
        String dkf_quit_key = OptionQuery.me().findValue("wechat_dkf_quit_key");
        if (StringUtils.isNotBlank((String)dkf_quit_key) && dkf_quit_key.equals(userInput)) {
            CacheKit.remove((String)"wechat_dkf", (Object)message.getFromUserName());
            String quit_message = OptionQuery.me().findValue("wechat_dkf_quit_message");
            OutTextMsg otm = new OutTextMsg(message);
            otm.setContent(quit_message);
            this.render((OutMsg)otm);
            return true;
        }
        Boolean isInDkf = (Boolean)CacheKit.get((String)"wechat_dkf", (Object)message.getFromUserName());
        if (isInDkf != null && isInDkf.booleanValue()) {
            CacheKit.remove((String)"wechat_dkf", (Object)message.getFromUserName());
            CacheKit.put((String)"wechat_dkf", (Object)message.getFromUserName(), (Object)true);
            OutCustomMsg outCustomMsg = new OutCustomMsg(message);
            this.render((OutMsg)outCustomMsg);
            return true;
        }
        String dkf_enter_key = OptionQuery.me().findValue("wechat_dkf_enter_key");
        if (StringUtils.isNotBlank((String)dkf_enter_key) && dkf_enter_key.equals(userInput)) {
            CacheKit.put((String)"wechat_dkf", (Object)message.getFromUserName(), (Object)true);
            String quit_message = OptionQuery.me().findValue("wechat_dkf_enter_message");
            OutTextMsg otm = new OutTextMsg(message);
            otm.setContent(quit_message);
            this.render((OutMsg)otm);
            return true;
        }
        return false;
    }

    private void processDefaultReplay(String optionKey, InMsg message) {
        String replyContent = OptionQuery.me().findValue(optionKey);
        if (StringUtils.isBlank((String)replyContent)) {
            this.renderNull();
            return;
        }
        this.textOrSeniorRender(message, replyContent);
    }

    private void textOrSeniorRender(InMsg message, String replyContent) {
        if (WechatMessageController.isSeniorReplay((String)replyContent)) {
            OutMsg outMsg = ProcesserManager.me().invoke(replyContent, message);
            if (outMsg != null) {
                this.render(outMsg);
            } else {
                this.renderConfigErrorMessage(message, replyContent);
            }
        } else {
            OutTextMsg outTextMsg = new OutTextMsg(message);
            outTextMsg.setContent(replyContent);
            this.render((OutMsg)outTextMsg);
        }
    }

    private void renderConfigErrorMessage(InMsg message, String replyContent) {
        OutTextMsg outTextMsg = new OutTextMsg(message);
        outTextMsg.setContent("\u914d\u7f6e\u9519\u8bef\uff0c\u6ca1\u6709\u9ad8\u7ea7\u56de\u590d " + replyContent + ",\u8bf7\u8054\u7cfb\u7f51\u7ad9\u7ba1\u7406\u5458\u3002");
        this.render((OutMsg)outTextMsg);
    }

    private static final boolean isSeniorReplay(String string) {
        return string != null && string.startsWith("[") && string.contains("]");
    }
}

