/*
 * Decompiled with CFR 0.152.
 */
package com.zrlog.web.config;

import com.hibegin.common.util.FileUtils;
import com.hibegin.common.util.IOUtil;
import com.hibegin.common.util.StringUtils;
import com.jfinal.aop.Interceptor;
import com.jfinal.config.Constants;
import com.jfinal.config.Handlers;
import com.jfinal.config.Interceptors;
import com.jfinal.config.JFinalConfig;
import com.jfinal.config.Plugins;
import com.jfinal.config.Routes;
import com.jfinal.core.JFinal;
import com.jfinal.handler.Handler;
import com.jfinal.kit.PathKit;
import com.jfinal.plugin.IPlugin;
import com.jfinal.plugin.activerecord.ActiveRecordPlugin;
import com.jfinal.plugin.activerecord.IDataSourceProvider;
import com.jfinal.plugin.hikaricp.HikariCpPlugin;
import com.jfinal.render.ViewType;
import com.jfinal.template.Engine;
import com.zrlog.admin.web.config.AdminRoutes;
import com.zrlog.admin.web.plugin.PluginCorePlugin;
import com.zrlog.admin.web.plugin.PluginCoreProcess;
import com.zrlog.admin.web.plugin.UpdateVersionPlugin;
import com.zrlog.blog.web.config.BlogRoutes;
import com.zrlog.blog.web.controller.api.ApiInstallController;
import com.zrlog.blog.web.handler.BlogArticleHandler;
import com.zrlog.blog.web.handler.GlobalResourceHandler;
import com.zrlog.blog.web.handler.PluginHandler;
import com.zrlog.blog.web.interceptor.InitDataInterceptor;
import com.zrlog.blog.web.interceptor.MyI18nInterceptor;
import com.zrlog.blog.web.plugin.CacheManagerPlugin;
import com.zrlog.blog.web.plugin.RequestStatisticsPlugin;
import com.zrlog.blog.web.version.UpgradeVersionHandler;
import com.zrlog.business.service.InstallAction;
import com.zrlog.business.util.InstallUtils;
import com.zrlog.model.Comment;
import com.zrlog.model.Link;
import com.zrlog.model.Log;
import com.zrlog.model.LogNav;
import com.zrlog.model.Plugin;
import com.zrlog.model.Tag;
import com.zrlog.model.Type;
import com.zrlog.model.User;
import com.zrlog.model.WebSite;
import com.zrlog.util.BlogBuildInfoUtil;
import com.zrlog.util.ZrLogUtil;
import com.zrlog.web.inteceptor.RouterInterceptor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ZrLogConfig
extends JFinalConfig
implements InstallAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZrLogConfig.class);
    private static final String DEFAULT_PREVIEW_DB_HOST = "demo.blog.zrlog.com";
    private static String jdbcUrl;
    private Plugins plugins;
    private boolean haveSqlUpdated = false;

    public ZrLogConfig() {
        if (ZrLogUtil.isBae()) {
            FileUtils.deleteFile((String)"/home/bae/backup");
        }
    }

    public static boolean isTest() {
        return "junit-test".equals(InstallUtils.getSystemProp().getProperty("env"));
    }

    public static boolean isPreviewDb() {
        return jdbcUrl != null && jdbcUrl.contains("demo.blog.zrlog.com") && !ZrLogUtil.isInternalHostName((String)"demo.blog.zrlog.com");
    }

    private String getUpgradeSqlBasePath() {
        return PathKit.getWebRootPath() + "/WEB-INF/update-sql";
    }

    private ActiveRecordPlugin getActiveRecordPlugin(IDataSourceProvider dataSourceProvider) {
        ActiveRecordPlugin arp = new ActiveRecordPlugin("c3p0Plugin" + new Random().nextInt(), dataSourceProvider);
        arp.addMapping("user", "userId", User.class);
        arp.addMapping("log", "logId", Log.class);
        arp.addMapping("type", "typeId", Type.class);
        arp.addMapping("link", "linkId", Link.class);
        arp.addMapping("comment", "commentId", Comment.class);
        arp.addMapping("lognav", "navId", LogNav.class);
        arp.addMapping("website", "siteId", WebSite.class);
        arp.addMapping("plugin", "pluginId", Plugin.class);
        arp.addMapping("tag", "tagId", Tag.class);
        return arp;
    }

    public void configConstant(Constants con) {
        con.setDevMode(BlogBuildInfoUtil.isDev());
        con.setViewType(ViewType.JSP);
        con.setEncoding("utf-8");
        con.setJsonDatePattern("yyyy-MM-dd");
        con.setError404View("/error/404.html");
        con.setError500View("/error/500.html");
        con.setError403View("/error/403.html");
        con.setBaseUploadPath(PathKit.getWebRootPath() + "/attached/");
        con.setMaxPostSize(0x40000000);
    }

    public void configHandler(Handlers handlers) {
        handlers.add((Handler)new GlobalResourceHandler());
        handlers.add((Handler)new BlogArticleHandler());
        handlers.add((Handler)new PluginHandler());
    }

    public void configInterceptor(Interceptors interceptors) {
        interceptors.add((Interceptor)new InitDataInterceptor());
        interceptors.add((Interceptor)new MyI18nInterceptor());
        interceptors.add((Interceptor)new RouterInterceptor());
    }

    public void configPlugin(Plugins plugins) {
        if (InstallUtils.isInstalled()) {
            if (StringUtils.isNotEmpty((String)ZrLogUtil.getDbInfoByEnv())) {
                IOUtil.writeBytesToFile((byte[])ZrLogUtil.getDbInfoByEnv().getBytes(), (File)new File(InstallUtils.getDbPropertiesFilePath()));
            }
            try {
                Properties dbProperties = InstallUtils.getDbProp();
                this.tryUpgradeDbPropertiesFile(InstallUtils.getDbPropertiesFilePath(), Objects.requireNonNull(dbProperties));
                this.tryDoUpgrade(this.getUpgradeSqlBasePath(), dbProperties.getProperty("jdbcUrl"), dbProperties.getProperty("user"), dbProperties.getProperty("password"), dbProperties.getProperty("driverClass"));
                jdbcUrl = dbProperties.getProperty("jdbcUrl");
                HikariCpPlugin dataSourcePlugin = new HikariCpPlugin(dbProperties.getProperty("jdbcUrl"), dbProperties.getProperty("user"), dbProperties.getProperty("password"));
                plugins.add((IPlugin)dataSourcePlugin);
                plugins.add((IPlugin)this.getActiveRecordPlugin((IDataSourceProvider)dataSourcePlugin));
                Object pluginJvmArgsObj = BlogBuildInfoUtil.getBlogProp().get("pluginJvmArgs");
                if (pluginJvmArgsObj == null) {
                    pluginJvmArgsObj = "";
                }
                if (!ZrLogConfig.isTest()) {
                    plugins.add((IPlugin)new PluginCorePlugin(InstallUtils.getDbPropertiesFilePath(), pluginJvmArgsObj.toString()));
                    plugins.add((IPlugin)new UpdateVersionPlugin());
                    plugins.add((IPlugin)new CacheManagerPlugin());
                }
                plugins.add((IPlugin)new RequestStatisticsPlugin());
            }
            catch (Exception e) {
                LOGGER.warn("configPlugin exception ", (Throwable)e);
            }
        } else {
            LOGGER.warn("Not found lock file(" + PathKit.getWebRootPath() + "/WEB-INF/install.lock), Please visit the http://yourHostName:port" + JFinal.me().getContextPath() + "/install start installation");
        }
        JFinal.me().getServletContext().setAttribute("plugins", (Object)plugins);
        this.plugins = plugins;
    }

    private void tryUpgradeDbPropertiesFile(String dbFile, Properties properties) throws IOException {
        if (!"com.mysql.cj.jdbc.Driver".equals(properties.get("driverClass"))) {
            properties.put("driverClass", "com.mysql.cj.jdbc.Driver");
            properties.put("jdbcUrl", properties.get("jdbcUrl") + "&" + ApiInstallController.JDBC_URL_BASE_QUERY_PARAM);
            properties.store(new FileOutputStream(dbFile), "Support mysql8");
        }
    }

    public void onStart() {
        int updatedVersion;
        super.onStart();
        JFinal.me().getServletContext().setAttribute("config", (Object)this);
        if (this.haveSqlUpdated && (updatedVersion = ZrLogUtil.getSqlVersion((String)this.getUpgradeSqlBasePath()).intValue()) > 0) {
            new WebSite().updateByKV("zrlogSqlVersion", (Object)(updatedVersion + ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryDoUpgrade(String basePath, String jdbcUrl, String user, String password, String driverClass) {
        String currentVersion = ZrLogUtil.getCurrentSqlVersion((String)jdbcUrl, (String)user, (String)password, (String)driverClass);
        List sqlList = ZrLogUtil.getExecSqlList((String)currentVersion, (String)basePath);
        if (!sqlList.isEmpty()) {
            try {
                for (Map.Entry entry : sqlList) {
                    Connection connection = ZrLogUtil.getConnection((String)jdbcUrl, (String)user, (String)password, (String)driverClass);
                    if (connection == null) continue;
                    Statement statement = connection.createStatement();
                    try {
                        for (String sql : (List)entry.getValue()) {
                            statement.execute(sql);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("execution sql ", (Throwable)e);
                        return;
                    }
                    finally {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException e) {
                                LOGGER.error("", (Throwable)e);
                            }
                        }
                    }
                    try {
                        UpgradeVersionHandler upgradeVersionHandler = (UpgradeVersionHandler)Class.forName("com.zrlog.web.version.V" + entry.getKey() + "UpgradeVersionHandler").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        try {
                            upgradeVersionHandler.doUpgrade(connection);
                        }
                        catch (Exception e) {
                            LOGGER.error("", (Throwable)e);
                            connection.close();
                            return;
                        }
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        LOGGER.warn("Try exec upgrade method error, " + e.getMessage());
                    }
                    finally {
                        connection.close();
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
            this.haveSqlUpdated = true;
        }
    }

    public void onStop() {
        PluginCoreProcess.getInstance().stopPluginCore();
        for (IPlugin plugin : this.plugins.getPluginList()) {
            plugin.stop();
        }
    }

    public void configRoute(Routes routes) {
        routes.add((Routes)new AdminRoutes());
        routes.add((Routes)new BlogRoutes());
    }

    public void configEngine(Engine engine) {
    }

    public void installFinish() {
        this.configPlugin(this.plugins);
        List pluginList = this.plugins.getPluginList();
        for (IPlugin plugin : pluginList) {
            plugin.start();
        }
    }
}

