/*
 * Decompiled with CFR 0.152.
 */
package com.zrlog.web.inteceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.core.ActionException;
import com.zrlog.admin.web.interceptor.AdminInterceptor;
import com.zrlog.blog.web.handler.GlobalResourceHandler;
import com.zrlog.blog.web.interceptor.VisitorInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterInterceptor
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouterInterceptor.class);
    private final VisitorInterceptor visitorInterceptor = new VisitorInterceptor();
    private final AdminInterceptor adminInterceptor = new AdminInterceptor();

    public void intercept(Invocation invocation) {
        try {
            String actionKey = invocation.getActionKey();
            if (actionKey.startsWith("/admin") || actionKey.startsWith("/api/admin")) {
                this.adminInterceptor.intercept(invocation);
            } else {
                this.visitorInterceptor.intercept(invocation);
            }
            GlobalResourceHandler.printUserTime((String)"Router");
        }
        catch (ActionException e) {
            invocation.getController().renderError(e.getErrorCode());
        }
        catch (Exception e) {
            LOGGER.error("interceptor exception ", (Throwable)e);
            invocation.getController().renderError(500);
        }
    }
}

