/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.codec;

import com.helger.commons.codec.DecodeException;
import com.helger.commons.codec.EncodeException;
import com.helger.commons.codec.ICharArrayCodec;
import com.helger.commons.string.StringHelper;
import com.helger.commons.text.util.ABNF;
import java.io.IOException;
import java.io.Writer;
import java.util.BitSet;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;

public class RFC2616Codec
implements ICharArrayCodec {
    private static final char QUOTE_CHAR = '\"';
    private static final char ESCAPE_CHAR = '\\';
    private static final BitSet NON_TOKEN_RFC2616 = new BitSet(256);

    public static boolean isToken(@Nullable String string) {
        if (string == null) {
            return false;
        }
        return RFC2616Codec.isToken(string.toCharArray());
    }

    public static boolean isToken(@Nullable char[] cArray) {
        if (cArray == null || cArray.length == 0) {
            return false;
        }
        for (char c : cArray) {
            if (!NON_TOKEN_RFC2616.get(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isMaybeEncoded(@Nullable String string) {
        return string != null && string.length() >= 2 && string.charAt(0) == '\"' && StringHelper.getLastChar(string) == '\"';
    }

    @Nonnegative
    public int getEncodedLength(@Nonnegative int n) {
        return 1 + 2 * n + 1;
    }

    @Override
    public void encode(@Nullable char[] cArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull @WillNotClose Writer writer) {
        if (cArray == null) {
            return;
        }
        try {
            writer.write(34);
            for (int i = 0; i < n2; ++i) {
                char c = cArray[n + i];
                if (c == '\\' || c == '\"') {
                    writer.write(92);
                }
                writer.write(c);
            }
            writer.write(34);
        }
        catch (IOException iOException) {
            throw new EncodeException("Failed to encode RFC2616", iOException);
        }
    }

    @Override
    public void decode(@Nullable char[] cArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull @WillNotClose Writer writer) {
        if (cArray == null) {
            return;
        }
        if (n2 < 2) {
            throw new DecodeException("At least the 2 quote characters must be present. Provided length is only " + n2);
        }
        if (cArray[n] != '\"') {
            throw new DecodeException("The provided bytes does not seem to be encoded. The first byte is not the double quote character.");
        }
        int n3 = n + n2 - 1;
        if (cArray[n3] != '\"') {
            throw new DecodeException("The provided bytes does not seem to be encoded. The last byte is not the double quote character.");
        }
        try {
            for (int i = n + 1; i < n3; ++i) {
                char c = cArray[i];
                if (c == '\\') {
                    if (i == n3 - 1) {
                        throw new DecodeException("The encoded string seems to be cut. The second last character cannot be an escape character.");
                    }
                    writer.write(cArray[++i]);
                    continue;
                }
                writer.write(c);
            }
        }
        catch (IOException iOException) {
            throw new DecodeException("Failed to decode RFC2616", iOException);
        }
    }

    static {
        for (int i = 0; i <= 127; ++i) {
            if (!ABNF.isCtl(i) && !ABNF.isSP(i) && !ABNF.isHTab(i)) continue;
            NON_TOKEN_RFC2616.set(i);
        }
        NON_TOKEN_RFC2616.set(40);
        NON_TOKEN_RFC2616.set(41);
        NON_TOKEN_RFC2616.set(60);
        NON_TOKEN_RFC2616.set(62);
        NON_TOKEN_RFC2616.set(64);
        NON_TOKEN_RFC2616.set(44);
        NON_TOKEN_RFC2616.set(59);
        NON_TOKEN_RFC2616.set(58);
        NON_TOKEN_RFC2616.set(92);
        NON_TOKEN_RFC2616.set(34);
        NON_TOKEN_RFC2616.set(47);
        NON_TOKEN_RFC2616.set(91);
        NON_TOKEN_RFC2616.set(93);
        NON_TOKEN_RFC2616.set(63);
        NON_TOKEN_RFC2616.set(61);
        NON_TOKEN_RFC2616.set(123);
        NON_TOKEN_RFC2616.set(125);
    }
}

