/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.email;

import com.helger.commons.regex.RegExCache;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class EmailAddressHelper {
    public static final String EMAIL_ADDRESS_PATTERN = "[a-z0-9!#\\$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#\\$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?";
    private static final Pattern s_aPattern = RegExCache.getPattern("[a-z0-9!#\\$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#\\$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?");

    private EmailAddressHelper() {
    }

    @Nullable
    public static String getUnifiedEmailAddress(@Nullable String string) {
        return string == null ? null : string.trim().toLowerCase(Locale.US);
    }

    public static boolean isValid(@Nullable String string) {
        if (string == null) {
            return false;
        }
        String string2 = EmailAddressHelper.getUnifiedEmailAddress(string);
        return s_aPattern.matcher(string2).matches();
    }
}

