/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.functional;

import com.helger.commons.ValueEnforcer;
import java.io.Serializable;
import javax.annotation.Nonnull;

@FunctionalInterface
public interface IBooleanPredicate
extends Serializable {
    public boolean test(boolean var1);

    @Nonnull
    default public IBooleanPredicate negate() {
        return bl -> !this.test(bl);
    }

    @Nonnull
    default public IBooleanPredicate and(@Nonnull IBooleanPredicate iBooleanPredicate) {
        ValueEnforcer.notNull(iBooleanPredicate, "Other");
        return bl -> this.test(bl) && iBooleanPredicate.test(bl);
    }

    @Nonnull
    default public IBooleanPredicate or(@Nonnull IBooleanPredicate iBooleanPredicate) {
        ValueEnforcer.notNull(iBooleanPredicate, "Other");
        return bl -> this.test(bl) || iBooleanPredicate.test(bl);
    }

    @Nonnull
    public static IBooleanPredicate all() {
        return bl -> true;
    }

    @Nonnull
    public static IBooleanPredicate none() {
        return bl -> false;
    }

    @Nonnull
    public static IBooleanPredicate ifTrue() {
        return bl -> bl;
    }

    @Nonnull
    public static IBooleanPredicate ifFalse() {
        return bl -> !bl;
    }
}

