/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jmeter.control.IfController;
import org.apache.jmeter.control.gui.AbstractControllerGui;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

@GUIMenuSortOrder(value=1)
public class IfControllerPanel
extends AbstractControllerGui
implements ChangeListener {
    private static final long serialVersionUID = 240L;
    private JLabel warningLabel;
    private JLabel conditionLabel;
    private JSyntaxTextArea theCondition;
    private JCheckBox useExpression;
    private JCheckBox evaluateAll;
    private boolean displayName = true;

    public IfControllerPanel() {
        this(true);
    }

    public IfControllerPanel(boolean displayName) {
        this.displayName = displayName;
        this.init();
    }

    @Override
    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof IfController) {
            IfController ifController = (IfController)element;
            this.theCondition.setText(ifController.getCondition());
            this.evaluateAll.setSelected(ifController.isEvaluateAll());
            this.useExpression.setSelected(ifController.isUseExpression());
        }
    }

    @Override
    public TestElement createTestElement() {
        IfController controller = new IfController();
        this.modifyTestElement(controller);
        return controller;
    }

    @Override
    public void modifyTestElement(TestElement controller) {
        this.configureTestElement(controller);
        if (controller instanceof IfController) {
            IfController ifController = (IfController)controller;
            ifController.setCondition(this.theCondition.getText());
            ifController.setEvaluateAll(this.evaluateAll.isSelected());
            ifController.setUseExpression(this.useExpression.isSelected());
        }
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.useExpression.setSelected(true);
        this.theCondition.setText("");
        this.evaluateAll.setSelected(false);
    }

    @Override
    public String getLabelResource() {
        return "if_controller_title";
    }

    private void init() {
        if (this.displayName) {
            this.setLayout(new BorderLayout(0, 5));
            this.setBorder(this.makeBorder());
            this.add((Component)this.makeTitlePanel(), "North");
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.add((Component)this.createConditionPanel(), "North");
            this.add((Component)mainPanel, "Center");
        } else {
            this.setLayout(new BorderLayout());
            this.add((Component)this.createConditionPanel(), "North");
        }
    }

    private JPanel createConditionPanel() {
        JPanel conditionPanel = new JPanel(new BorderLayout(5, 0));
        this.conditionLabel = new JLabel(JMeterUtils.getResString("if_controller_label"));
        conditionPanel.add((Component)this.conditionLabel, "West");
        ImageIcon image = JMeterUtils.getImage("warning.png");
        this.warningLabel = new JLabel(JMeterUtils.getResString("if_controller_warning"), image, 0);
        this.warningLabel.setForeground(Color.RED);
        Font font = this.warningLabel.getFont();
        this.warningLabel.setFont(new Font(font.getFontName(), 1, (int)((double)font.getSize() * 1.1)));
        this.theCondition = JSyntaxTextArea.getInstance(5, 50);
        this.conditionLabel.setLabelFor((Component)((Object)this.theCondition));
        conditionPanel.add((Component)((Object)JTextScrollPane.getInstance(this.theCondition)), "Center");
        conditionPanel.add((Component)this.warningLabel, "North");
        JPanel optionPanel = new JPanel();
        this.useExpression = new JCheckBox(JMeterUtils.getResString("if_controller_expression"));
        this.useExpression.addChangeListener(this);
        optionPanel.add(this.useExpression);
        this.evaluateAll = new JCheckBox(JMeterUtils.getResString("if_controller_evaluate_all"));
        optionPanel.add(this.evaluateAll);
        conditionPanel.add((Component)optionPanel, "South");
        return conditionPanel;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.useExpression) {
            if (this.useExpression.isSelected()) {
                this.warningLabel.setForeground(Color.BLACK);
                this.conditionLabel.setText(JMeterUtils.getResString("if_controller_expression_label"));
            } else {
                this.warningLabel.setForeground(Color.RED);
                this.conditionLabel.setText(JMeterUtils.getResString("if_controller_label"));
            }
        }
    }
}

