/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.action.Copy;
import org.apache.jmeter.gui.tree.JMeterTreeListener;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.MenuFactory;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Paste
extends AbstractAction {
    private static final Logger log = LoggerFactory.getLogger(Paste.class);
    private static final Set<String> commands = new HashSet<String>();

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    @Override
    public void doAction(ActionEvent e) {
        JMeterTreeNode[] draggedNodes = Copy.getCopiedNodes();
        if (draggedNodes == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        JMeterTreeListener treeListener = GuiPackage.getInstance().getTreeListener();
        JMeterTreeNode currentNode = treeListener.getCurrentNode();
        if (MenuFactory.canAddTo(currentNode, draggedNodes)) {
            Arrays.stream(draggedNodes).filter(Objects::nonNull).forEach(draggedNode -> this.addNode(currentNode, (JMeterTreeNode)draggedNode));
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
        GuiPackage.getInstance().getMainFrame().repaint();
    }

    private void addNode(JMeterTreeNode parent, JMeterTreeNode node) {
        try {
            JMeterTreeNode newNode = GuiPackage.getInstance().getTreeModel().addComponent(node.getTestElement(), parent);
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.addNode(newNode, (JMeterTreeNode)node.getChildAt(i));
            }
        }
        catch (IllegalUserActionException iuae) {
            log.error("Illegal user action while adding a tree node.", (Throwable)iuae);
            JMeterUtils.reportErrorToUser(iuae.getMessage());
        }
    }

    static {
        commands.add("Paste");
    }
}

