/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.core.SampleException;
import org.apache.jmeter.report.core.SampleMetadata;
import org.apache.jmeter.report.processor.AbstractSampleConsumer;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalizerSampleConsumer
extends AbstractSampleConsumer {
    private static final Logger log = LoggerFactory.getLogger(NormalizerSampleConsumer.class);
    private static final String TIMESTAMP_FORMAT = JMeterUtils.getPropDefault("jmeter.save.saveservice.timestamp_format", "ms");
    private static final String PARSE_TIMESTAMP_EXCEPTION_MESSAGE = "Could not parse timeStamp <%s> using format defined by property jmeter.save.saveservice.timestamp_format=%s on sample %s ";
    private int timestamp;
    private boolean isMillisFormat;
    private final SimpleDateFormat dateFormat = this.createFormatter();
    private SampleMetadata sampleMetadata;

    @Override
    public void startConsuming() {
        this.sampleMetadata = this.getConsumedMetadata(0);
        this.timestamp = this.sampleMetadata.ensureIndexOf("timeStamp");
        super.setProducedMetadata(this.sampleMetadata, 0);
        this.startProducing();
    }

    private SimpleDateFormat createFormatter() {
        if ("none".equalsIgnoreCase(TIMESTAMP_FORMAT)) {
            throw new SampleException("'none' format for 'jmeter.save.saveservice.timestamp_format' property is not accepted for report generation");
        }
        log.info("Using format, '{}', to parse timeStamp field", (Object)TIMESTAMP_FORMAT);
        this.isMillisFormat = "ms".equalsIgnoreCase(TIMESTAMP_FORMAT);
        SimpleDateFormat formatter = null;
        if (!this.isMillisFormat) {
            formatter = new SimpleDateFormat(TIMESTAMP_FORMAT);
        }
        return formatter;
    }

    @Override
    public void consume(Sample s, int channel) {
        Date date = null;
        try {
            String tStr = s.getData(this.timestamp);
            date = this.isMillisFormat ? new Date(Long.parseLong(tStr)) : this.dateFormat.parse(tStr);
        }
        catch (Exception e) {
            throw new SampleException(String.format(PARSE_TIMESTAMP_EXCEPTION_MESSAGE, s.getData(this.timestamp), TIMESTAMP_FORMAT, s.toString()), e);
        }
        long time = date.getTime();
        int cc = this.sampleMetadata.getColumnCount();
        String[] data = new String[cc];
        for (int i = 0; i < cc; ++i) {
            data[i] = i == this.timestamp ? Long.toString(time) : s.getData(i);
        }
        Sample rewritten = new Sample(s.getSampleRow(), this.sampleMetadata, data);
        super.produce(rewritten, 0);
    }

    @Override
    public void stopConsuming() {
        super.stopProducing();
    }
}

