/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.reporters.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.apache.jmeter.reporters.ResultSaver;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.gui.AbstractListenerGui;
import org.apache.jorphan.gui.JLabeledTextField;

public class ResultSaverGui
extends AbstractListenerGui
implements Clearable {
    private static final long serialVersionUID = 241L;
    private JLabeledTextField filename;
    private JLabeledTextField variableName;
    private JLabeledTextField numberPadLength;
    private JCheckBox errorsOnly;
    private JCheckBox successOnly;
    private JCheckBox ignoreTC;
    private JCheckBox skipAutoNumber;
    private JCheckBox skipSuffix;
    private JCheckBox addTimestamp;

    public ResultSaverGui() {
        this.init();
    }

    @Override
    public String getLabelResource() {
        return "resultsaver_title";
    }

    @Override
    public void configure(TestElement el) {
        super.configure(el);
        ResultSaver resultSaver = (ResultSaver)el;
        this.filename.setText(resultSaver.getFilename());
        this.errorsOnly.setSelected(resultSaver.getErrorsOnly());
        this.successOnly.setSelected(resultSaver.getSuccessOnly());
        this.ignoreTC.setSelected(resultSaver.getIgnoreTC());
        this.skipAutoNumber.setSelected(resultSaver.getSkipAutoNumber());
        this.skipSuffix.setSelected(resultSaver.getSkipSuffix());
        this.variableName.setText(resultSaver.getVariableName());
        this.addTimestamp.setSelected(resultSaver.getAddTimeStamp());
        this.numberPadLength.setText(resultSaver.getNumberPadLen() == 0 ? "" : Integer.toString(resultSaver.getNumberPadLen()));
    }

    @Override
    public TestElement createTestElement() {
        ResultSaver resultSaver = new ResultSaver();
        this.modifyTestElement(resultSaver);
        return resultSaver;
    }

    @Override
    public void modifyTestElement(TestElement te) {
        super.configureTestElement(te);
        ResultSaver resultSaver = (ResultSaver)te;
        resultSaver.setFilename(this.filename.getText());
        resultSaver.setErrorsOnly(this.errorsOnly.isSelected());
        resultSaver.setSuccessOnly(this.successOnly.isSelected());
        resultSaver.setSkipSuffix(this.skipSuffix.isSelected());
        resultSaver.setSkipAutoNumber(this.skipAutoNumber.isSelected());
        resultSaver.setIgnoreTC(this.ignoreTC.isSelected());
        resultSaver.setAddTimestamp(this.addTimestamp.isSelected());
        resultSaver.setVariableName(this.variableName.getText());
        resultSaver.setNumberPadLength(this.numberPadLength.getText());
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.skipAutoNumber.setSelected(false);
        this.skipSuffix.setSelected(false);
        this.filename.setText("");
        this.errorsOnly.setSelected(false);
        this.successOnly.setSelected(false);
        this.ignoreTC.setSelected(true);
        this.addTimestamp.setSelected(false);
        this.variableName.setText("");
        this.numberPadLength.setText("");
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        Box box = Box.createVerticalBox();
        box.add(this.makeTitlePanel());
        box.add(this.createSaveConditionsPanel());
        box.add(this.createSaveFormatPanel());
        this.add((Component)box, "North");
    }

    private Component createSaveFormatPanel() {
        this.filename = new JLabeledTextField(JMeterUtils.getResString("resultsaver_prefix"));
        this.filename.setName("FileSaver.filename");
        this.numberPadLength = new JLabeledTextField(JMeterUtils.getResString("resultsaver_numberpadlen"));
        this.numberPadLength.setName("FileSaver.numberPadLen");
        this.skipAutoNumber = new JCheckBox(JMeterUtils.getResString("resultsaver_skipautonumber"));
        this.skipSuffix = new JCheckBox(JMeterUtils.getResString("resultsaver_skipsuffix"));
        this.addTimestamp = new JCheckBox(JMeterUtils.getResString("resultsaver_addtimestamp"));
        this.variableName = new JLabeledTextField(JMeterUtils.getResString("resultsaver_variable"));
        this.variableName.setName("FileSaver.variablename");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString("resultsaver_save_format")));
        GridBagConstraints gbc = new GridBagConstraints();
        this.initConstraints(gbc);
        this.addField(panel, this.variableName, gbc);
        this.resetContraints(gbc);
        this.addField(panel, this.filename, gbc);
        this.resetContraints(gbc);
        this.addField(panel, this.skipAutoNumber, gbc);
        this.resetContraints(gbc);
        this.addField(panel, this.skipSuffix, gbc);
        this.resetContraints(gbc);
        this.addField(panel, this.addTimestamp, gbc);
        this.resetContraints(gbc);
        this.addField(panel, this.numberPadLength, gbc);
        this.resetContraints(gbc);
        return panel;
    }

    private Component createSaveConditionsPanel() {
        this.successOnly = new JCheckBox(JMeterUtils.getResString("resultsaver_success"));
        this.errorsOnly = new JCheckBox(JMeterUtils.getResString("resultsaver_errors"));
        this.ignoreTC = new JCheckBox(JMeterUtils.getResString("resultsaver_ignore_tc"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString("resultsaver_save_conditions")));
        GridBagConstraints gbc = new GridBagConstraints();
        this.initConstraints(gbc);
        this.addField(panel, this.successOnly, gbc);
        this.resetContraints(gbc);
        this.addField(panel, this.errorsOnly, gbc);
        this.resetContraints(gbc);
        this.addField(panel, this.ignoreTC, gbc);
        this.resetContraints(gbc);
        return panel;
    }

    @Override
    public void clearData() {
    }

    private void addField(JPanel panel, JCheckBox field, GridBagConstraints gbc) {
        gbc.weightx = 2.0;
        gbc.fill = 2;
        panel.add((Component)field, gbc.clone());
    }

    private void addField(JPanel panel, JLabeledTextField field, GridBagConstraints gbc) {
        List item = field.getComponentList();
        panel.add((Component)item.get(0), gbc.clone());
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel.add((Component)item.get(1), gbc.clone());
    }

    private void resetContraints(GridBagConstraints gbc) {
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.fill = 0;
    }

    private void initConstraints(GridBagConstraints gbc) {
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
    }
}

