/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jdbc.config;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.protocol.jdbc.config.DataSourceElementBeanInfo;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testbeans.TestBeanHelper;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceElement
extends AbstractTestElement
implements ConfigElement,
TestStateListener,
TestBean {
    private static final Logger log = LoggerFactory.getLogger(DataSourceElement.class);
    private static final long serialVersionUID = 234L;
    private transient String dataSource;
    private transient String driver;
    private transient String dbUrl;
    private transient String username;
    private transient String password;
    private transient String checkQuery;
    private transient String connectionProperties;
    private transient String initQuery;
    private transient String poolMax;
    private transient String connectionAge;
    private transient String timeout;
    private transient String trimInterval;
    private transient String transactionIsolation;
    private transient boolean keepAlive;
    private transient boolean autocommit;
    private transient boolean preinit;
    private transient BasicDataSource dbcpDataSource;
    private transient Set<BasicDataSource> perThreadPoolSet;
    private static final ThreadLocal<Map<String, BasicDataSource>> perThreadPoolMap = ThreadLocal.withInitial(HashMap::new);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnded() {
        DataSourceElement dataSourceElement = this;
        synchronized (dataSourceElement) {
            if (this.dbcpDataSource != null) {
                try {
                    this.dbcpDataSource.close();
                }
                catch (SQLException ex) {
                    log.error("Error closing pool: {}", (Object)this.getName(), (Object)ex);
                }
            }
            this.dbcpDataSource = null;
        }
        if (this.perThreadPoolSet != null) {
            for (BasicDataSource dsc : this.perThreadPoolSet) {
                log.debug("Closing pool: {}@{}", (Object)this.getDataSourceName(), (Object)System.identityHashCode(dsc));
                try {
                    dsc.close();
                }
                catch (SQLException ex) {
                    log.error("Error closing pool:{}", (Object)this.getName(), (Object)ex);
                }
            }
            this.perThreadPoolSet = null;
        }
    }

    public void testEnded(String host) {
        this.testEnded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStarted() {
        this.setRunningVersion(true);
        TestBeanHelper.prepare((TestElement)this);
        JMeterVariables variables = this.getThreadContext().getVariables();
        String poolName = this.getDataSource();
        if (JOrphanUtils.isBlank((String)poolName)) {
            throw new IllegalArgumentException("Variable Name must not be empty for element:" + this.getName());
        }
        if (variables.getObject(poolName) != null) {
            log.error("JDBC data source already defined for: {}", (Object)poolName);
        } else {
            String maxPool = this.getPoolMax();
            this.perThreadPoolSet = Collections.synchronizedSet(new HashSet());
            if (maxPool.equals("0")) {
                variables.putObject(poolName, (Object)new DataSourceComponentImpl());
            } else {
                BasicDataSource src = this.initPool(maxPool);
                DataSourceElement dataSourceElement = this;
                synchronized (dataSourceElement) {
                    this.dbcpDataSource = src;
                    variables.putObject(poolName, (Object)new DataSourceComponentImpl(this.dbcpDataSource));
                }
            }
        }
    }

    public void testStarted(String host) {
        this.testStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        DataSourceElement el = (DataSourceElement)((Object)super.clone());
        DataSourceElement dataSourceElement = this;
        synchronized (dataSourceElement) {
            el.dbcpDataSource = this.dbcpDataSource;
            el.perThreadPoolSet = this.perThreadPoolSet;
        }
        return el;
    }

    public static String getConnectionInfo(String poolName) throws SQLException {
        Object poolObject = JMeterContextService.getContext().getVariables().getObject(poolName);
        if (poolObject instanceof DataSourceComponentImpl) {
            DataSourceComponentImpl pool = (DataSourceComponentImpl)poolObject;
            return pool.getConnectionInfo();
        }
        return "Object:" + poolName + " is not of expected type '" + DataSourceComponentImpl.class.getName() + "'";
    }

    public static Connection getConnection(String poolName) throws SQLException {
        Object poolObject = JMeterContextService.getContext().getVariables().getObject(poolName);
        if (poolObject == null) {
            throw new SQLException("No pool found named: '" + poolName + "', ensure Variable Name matches Variable Name of JDBC Connection Configuration");
        }
        if (poolObject instanceof DataSourceComponentImpl) {
            DataSourceComponentImpl pool = (DataSourceComponentImpl)poolObject;
            return pool.getConnection();
        }
        String errorMsg = "Found object stored under variable:'" + poolName + "' with class:" + poolObject.getClass().getName() + " and value: '" + poolObject + " but it's not a DataSourceComponent, check you're not already using this name as another variable";
        log.error(errorMsg);
        throw new SQLException(errorMsg);
    }

    private BasicDataSource initPool(String maxPool) {
        BasicDataSource dataSource;
        block15: {
            int transactionIsolation;
            dataSource = new BasicDataSource();
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder(40);
                sb.append("MaxPool: ");
                sb.append(maxPool);
                sb.append(" Timeout: ");
                sb.append(this.getTimeout());
                sb.append(" TrimInt: ");
                sb.append(this.getTrimInterval());
                sb.append(" Auto-Commit: ");
                sb.append(this.isAutocommit());
                sb.append(" Preinit: ");
                sb.append(this.isPreinit());
                log.debug(sb.toString());
            }
            int poolSize = Integer.parseInt(maxPool);
            dataSource.setMinIdle(0);
            dataSource.setInitialSize(poolSize);
            dataSource.setEnableAutoCommitOnReturn(false);
            if (StringUtils.isNotEmpty((CharSequence)this.initQuery)) {
                String[] sqls = this.initQuery.split("\n");
                dataSource.setConnectionInitSqls(Arrays.asList(sqls));
            } else {
                dataSource.setConnectionInitSqls(Collections.emptyList());
            }
            if (StringUtils.isNotEmpty((CharSequence)this.connectionProperties)) {
                dataSource.setConnectionProperties(this.connectionProperties);
            }
            dataSource.setRollbackOnReturn(false);
            dataSource.setMaxIdle(poolSize);
            dataSource.setMaxTotal(poolSize);
            dataSource.setMaxWaitMillis(Long.parseLong(this.getTimeout()));
            dataSource.setDefaultAutoCommit(Boolean.valueOf(this.isAutocommit()));
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder(40);
                sb.append("KeepAlive: ");
                sb.append(this.isKeepAlive());
                sb.append(" Age: ");
                sb.append(this.getConnectionAge());
                sb.append(" CheckQuery: ");
                sb.append(this.getCheckQuery());
                log.debug(sb.toString());
            }
            dataSource.setTestOnBorrow(false);
            dataSource.setTestOnReturn(false);
            dataSource.setTestOnCreate(false);
            dataSource.setTestWhileIdle(false);
            if (this.isKeepAlive()) {
                dataSource.setTestWhileIdle(true);
                String validationQuery = this.getCheckQuery();
                if (StringUtils.isBlank((CharSequence)validationQuery)) {
                    dataSource.setValidationQuery(null);
                } else {
                    dataSource.setValidationQuery(validationQuery);
                }
                dataSource.setSoftMinEvictableIdleTimeMillis(Long.parseLong(this.getConnectionAge()));
                dataSource.setTimeBetweenEvictionRunsMillis((long)Integer.parseInt(this.getTrimInterval()));
            }
            if ((transactionIsolation = DataSourceElementBeanInfo.getTransactionIsolationMode(this.getTransactionIsolation())) >= 0) {
                dataSource.setDefaultTransactionIsolation(transactionIsolation);
            }
            String _username = this.getUsername();
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder(40);
                sb.append("Driver: ");
                sb.append(this.getDriver());
                sb.append(" DbUrl: ");
                sb.append(this.getDbUrl());
                sb.append(" User: ");
                sb.append(_username);
                log.debug(sb.toString());
            }
            dataSource.setDriverClassName(this.getDriver());
            dataSource.setUrl(this.getDbUrl());
            if (_username.length() > 0) {
                dataSource.setUsername(_username);
                dataSource.setPassword(this.getPassword());
            }
            if (this.isPreinit()) {
                try {
                    dataSource.getConnection().close();
                    if (log.isDebugEnabled()) {
                        log.debug("Preinitializing the connection pool: {}@{}", (Object)this.getDataSourceName(), (Object)System.identityHashCode(dataSource));
                    }
                }
                catch (SQLException ex) {
                    if (!log.isErrorEnabled()) break block15;
                    log.error("Error preinitializing the connection pool: {}@{}", new Object[]{this.getDataSourceName(), System.identityHashCode(dataSource), ex});
                }
            }
        }
        log.debug("PoolConfiguration:{}", (Object)this.dataSource);
        return dataSource;
    }

    public void addConfigElement(ConfigElement config) {
    }

    public boolean expectsModification() {
        return false;
    }

    public String getCheckQuery() {
        return this.checkQuery;
    }

    public void setCheckQuery(String checkQuery) {
        this.checkQuery = checkQuery;
    }

    public String getConnectionAge() {
        return this.connectionAge;
    }

    public void setConnectionAge(String connectionAge) {
        this.connectionAge = connectionAge;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    private String getDataSourceName() {
        return this.getDataSource();
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPoolMax() {
        return this.poolMax;
    }

    public void setPoolMax(String poolMax) {
        this.poolMax = poolMax;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getTrimInterval() {
        return this.trimInterval;
    }

    public void setTrimInterval(String trimInterval) {
        this.trimInterval = trimInterval;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isAutocommit() {
        return this.autocommit;
    }

    public void setAutocommit(boolean autocommit) {
        this.autocommit = autocommit;
    }

    public boolean isPreinit() {
        return this.preinit;
    }

    public void setPreinit(boolean preinit) {
        this.preinit = preinit;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public String getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public void setTransactionIsolation(String transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
    }

    public String getInitQuery() {
        return this.initQuery;
    }

    public void setInitQuery(String initQuery) {
        this.initQuery = initQuery;
    }

    public String getConnectionProperties() {
        return this.connectionProperties;
    }

    public void setConnectionProperties(String connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    private class DataSourceComponentImpl {
        private final BasicDataSource sharedDSC;

        DataSourceComponentImpl() {
            this.sharedDSC = null;
        }

        DataSourceComponentImpl(BasicDataSource dsc) {
            this.sharedDSC = dsc;
        }

        public String getConnectionInfo() {
            BasicDataSource dsc = this.getConfiguredDataSource();
            StringBuilder builder = new StringBuilder(100);
            builder.append("shared:").append(this.sharedDSC != null).append(", driver:").append(dsc.getDriverClassName()).append(", url:").append(dsc.getUrl()).append(", user:").append(dsc.getUsername());
            return builder.toString();
        }

        public Connection getConnection() throws SQLException {
            BasicDataSource dsc = this.getConfiguredDataSource();
            Connection conn = dsc.getConnection();
            int isolation = DataSourceElementBeanInfo.getTransactionIsolationMode(DataSourceElement.this.getTransactionIsolation());
            if (isolation >= 0 && conn.getTransactionIsolation() != isolation) {
                try {
                    conn.setTransactionIsolation(isolation);
                    log.debug("Setting transaction isolation: {}@{}", (Object)isolation, (Object)System.identityHashCode(dsc));
                }
                catch (SQLException ex) {
                    log.error("Could not set transaction isolation: {}@{}", new Object[]{isolation, System.identityHashCode(dsc), ex});
                }
            }
            return conn;
        }

        private BasicDataSource getConfiguredDataSource() {
            BasicDataSource dsc;
            if (this.sharedDSC != null) {
                dsc = this.sharedDSC;
            } else {
                Map poolMap = (Map)perThreadPoolMap.get();
                dsc = (BasicDataSource)poolMap.get(DataSourceElement.this.getDataSourceName());
                if (dsc == null) {
                    dsc = DataSourceElement.this.initPool("1");
                    poolMap.put(DataSourceElement.this.getDataSourceName(), dsc);
                    log.debug("Storing pool: {}@{}", (Object)DataSourceElement.this.getName(), (Object)System.identityHashCode(dsc));
                    DataSourceElement.this.perThreadPoolSet.add(dsc);
                }
            }
            return dsc;
        }
    }
}

