/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.Map;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Promise;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Value;

public class PingResponseHandler
implements ResponseHandler {
    private final Promise<Boolean> result;
    private final Channel channel;
    private final Logger log;

    public PingResponseHandler(Promise<Boolean> result, Channel channel, Logger log) {
        this.result = result;
        this.channel = channel;
        this.log = log;
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        this.log.trace("Channel %s pinged successfully", this.channel);
        this.result.setSuccess(true);
    }

    @Override
    public void onFailure(Throwable error) {
        this.log.trace("Channel %s failed ping %s", this.channel, error);
        this.result.setSuccess(false);
    }

    @Override
    public void onRecord(Value[] fields) {
        throw new UnsupportedOperationException();
    }
}

