/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jmeter.assertions.JSONPathAssertion;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextArea;
import org.apache.jorphan.gui.JLabeledTextField;

@GUIMenuSortOrder(value=2)
public class JSONPathAssertionGui
extends AbstractAssertionGui
implements ChangeListener {
    private static final long serialVersionUID = -6008018002423594040L;
    private static final String JSON_ASSERTION_PATH = "json_assertion_path";
    private static final String JSON_ASSERTION_VALIDATION = "json_assertion_validation";
    private static final String JSON_ASSERTION_REGEX = "json_assertion_regex";
    private static final String JSON_ASSERTION_EXPECTED_VALUE = "json_assertion_expected_value";
    private static final String JSON_ASSERTION_NULL = "json_assertion_null";
    private static final String JSON_ASSERTION_INVERT = "json_assertion_invert";
    private static final String JSON_ASSERTION_TITLE = "json_assertion_title";
    protected JLabeledTextField jsonPath = null;
    protected JLabeledTextArea jsonValue = null;
    protected JCheckBox jsonValidation = null;
    protected JCheckBox expectNull = null;
    protected JCheckBox invert = null;
    protected JCheckBox isRegex;

    public JSONPathAssertionGui() {
        this.init();
    }

    void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        VerticalPanel panel = new VerticalPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.initFields();
        this.jsonValidation.addChangeListener(this);
        this.expectNull.addChangeListener(this);
        panel.add((Component)this.jsonPath);
        panel.add((Component)this.jsonValidation);
        panel.add((Component)this.isRegex);
        panel.add((Component)this.jsonValue);
        panel.add((Component)this.expectNull);
        panel.add((Component)this.invert);
        this.add((Component)panel, "Center");
    }

    protected void initFields() {
        this.jsonPath = new JLabeledTextField(JMeterUtils.getResString((String)JSON_ASSERTION_PATH));
        this.jsonValue = new JLabeledTextArea(JMeterUtils.getResString((String)JSON_ASSERTION_EXPECTED_VALUE));
        this.jsonValidation = new JCheckBox(JMeterUtils.getResString((String)JSON_ASSERTION_VALIDATION));
        this.expectNull = new JCheckBox(JMeterUtils.getResString((String)JSON_ASSERTION_NULL));
        this.invert = new JCheckBox(JMeterUtils.getResString((String)JSON_ASSERTION_INVERT));
        this.isRegex = new JCheckBox(JMeterUtils.getResString((String)JSON_ASSERTION_REGEX));
    }

    public void clearGui() {
        super.clearGui();
        this.jsonPath.setText("");
        this.jsonValue.setText("");
        this.jsonValidation.setSelected(false);
        this.expectNull.setSelected(false);
        this.invert.setSelected(false);
        this.isRegex.setSelected(true);
    }

    public TestElement createTestElement() {
        JSONPathAssertion jpAssertion = new JSONPathAssertion();
        this.modifyTestElement((TestElement)jpAssertion);
        return jpAssertion;
    }

    public String getLabelResource() {
        return JSON_ASSERTION_TITLE;
    }

    public void modifyTestElement(TestElement element) {
        super.configureTestElement(element);
        if (element instanceof JSONPathAssertion) {
            JSONPathAssertion jpAssertion = (JSONPathAssertion)element;
            jpAssertion.setJsonPath(this.jsonPath.getText());
            jpAssertion.setExpectedValue(this.jsonValue.getText());
            jpAssertion.setJsonValidationBool(this.jsonValidation.isSelected());
            jpAssertion.setExpectNull(this.expectNull.isSelected());
            jpAssertion.setInvert(this.invert.isSelected());
            jpAssertion.setIsRegex(this.isRegex.isSelected());
        }
    }

    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof JSONPathAssertion) {
            JSONPathAssertion jpAssertion = (JSONPathAssertion)element;
            this.jsonPath.setText(jpAssertion.getJsonPath());
            this.jsonValue.setText(jpAssertion.getExpectedValue());
            this.jsonValidation.setSelected(jpAssertion.isJsonValidationBool());
            this.expectNull.setSelected(jpAssertion.isExpectNull());
            this.invert.setSelected(jpAssertion.isInvert());
            this.isRegex.setSelected(jpAssertion.isUseRegex());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.jsonValue.setEnabled(this.jsonValidation.isSelected() && !this.expectNull.isSelected());
        this.isRegex.setEnabled(this.jsonValidation.isSelected() && !this.expectNull.isSelected());
    }
}

