/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.SaveGraphics;
import org.apache.jmeter.gui.util.FilePanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.RespTimeGraphChart;
import org.apache.jmeter.visualizers.RespTimeGraphDataBean;
import org.apache.jmeter.visualizers.RespTimeGraphLineBean;
import org.apache.jmeter.visualizers.StatGraphProperties;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;
import org.apache.jmeter.visualizers.utils.Colors;
import org.apache.jorphan.gui.GuiUtils;
import org.apache.jorphan.gui.JLabeledTextField;
import org.apache.jorphan.math.StatCalculatorLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RespTimeGraphVisualizer
extends AbstractVisualizer
implements ActionListener,
Clearable {
    private static final long serialVersionUID = 281L;
    private static final Logger log = LoggerFactory.getLogger(RespTimeGraphVisualizer.class);
    private static final Font FONT_DEFAULT = UIManager.getDefaults().getFont("TextField.font");
    private static final Font FONT_SMALL = new Font("SansSerif", 0, (int)Math.round((double)FONT_DEFAULT.getSize() * 0.8));
    public static final String INTERVAL = "RespTimeGraph.interval";
    public static final String SERIES_SELECTION = "RespTimeGraph.seriesselection";
    public static final String SERIES_SELECTION_MATCH_LABEL = "RespTimeGraph.seriesselectionmatchlabel";
    public static final String SERIES_SELECTION_CASE_SENSITIVE = "RespTimeGraph.seriesselectioncasesensitive";
    public static final String SERIES_SELECTION_REGEXP = "RespTimeGraph.seriesselectionregexp";
    public static final String GRAPH_TITLE = "RespTimeGraph.graphtitle";
    public static final String GRAPH_TITLE_FONT_NAME = "RespTimeGraph.graphtitlefontname";
    public static final String GRAPH_TITLE_FONT_SIZE = "RespTimeGraph.graphtitlefondsize";
    public static final String GRAPH_TITLE_FONT_STYLE = "RespTimeGraph.graphtitlefontstyle";
    public static final String LINE_STROKE_WIDTH = "RespTimeGraph.linestrockwidth";
    public static final String LINE_SHAPE_POINT = "RespTimeGraph.lineshapepoint";
    public static final String GRAPH_SIZE_DYNAMIC = "RespTimeGraph.graphsizedynamic";
    public static final String GRAPH_SIZE_WIDTH = "RespTimeGraph.graphsizewidth";
    public static final String GRAPH_SIZE_HEIGHT = "RespTimeGraph.graphsizeheight";
    public static final String XAXIS_TIME_FORMAT = "RespTimeGraph.xaxistimeformat";
    public static final String YAXIS_SCALE_MAX_VALUE = "RespTimeGraph.yaxisscalemaxvalue";
    public static final String YAXIS_INCREMENT_SCALE = "RespTimeGraph.yaxisscaleincrement";
    public static final String YAXIS_NUMBER_GROUPING = "RespTimeGraph.yaxisnumbergrouping";
    public static final String LEGEND_PLACEMENT = "RespTimeGraph.legendplacement";
    public static final String LEGEND_FONT = "RespTimeGraph.legendfont";
    public static final String LEGEND_SIZE = "RespTimeGraph.legendsize";
    public static final String LEGEND_STYLE = "RespTimeGraph.legendstyle";
    public static final int DEFAULT_INTERVAL = 10000;
    public static final boolean DEFAULT_SERIES_SELECTION = false;
    public static final boolean DEFAULT_CASE_SENSITIVE = false;
    public static final boolean DEFAULT_REGEXP = true;
    public static final int DEFAULT_TITLE_FONT_NAME = 0;
    public static final int DEFAULT_TITLE_FONT_SIZE = 6;
    public static final int DEFAULT_TITLE_FONT_STYLE = 1;
    public static final int DEFAULT_STROKE_WIDTH_LIST = 4;
    public static final int DEFAULT_LINE_SHAPE_POINT = 0;
    public static final boolean DEFAULT_DYNAMIC_GRAPH_SIZE = true;
    public static final String DEFAULT_XAXIS_TIME_FORMAT = "HH:mm:ss";
    public static final boolean DEFAULT_NUMBER_SHOW_GROUPING = true;
    public static final int DEFAULT_LEGEND_PLACEMENT = 0;
    public static final int DEFAULT_LEGEND_FONT = 0;
    public static final int DEFAULT_LEGEND_SIZE = 2;
    public static final int DEFAULT_LEGEND_STYLE = 0;
    private static final int DEFAULT_WIDTH = 400;
    private static final int DEFAULT_HEIGTH = 300;
    private static final String Y_AXIS_LABEL = JMeterUtils.getResString((String)"aggregate_graph_response_time");
    private static final String Y_AXIS_TITLE = JMeterUtils.getResString((String)"aggregate_graph_ms");
    private final transient Object lock = new Object();
    private final transient Object lockInterval = new Object();
    private RespTimeGraphChart graphPanel = null;
    private final JTabbedPane tabbedGraph = new JTabbedPane(1);
    private boolean saveGraphToFile = false;
    private int intervalValue = 10000;
    private final JLabeledTextField intervalField = new JLabeledTextField(JMeterUtils.getResString((String)"graph_resp_time_interval_label"), 7);
    private final JButton intervalButton = new JButton(JMeterUtils.getResString((String)"graph_resp_time_interval_reload"));
    private final JButton displayButton = new JButton(JMeterUtils.getResString((String)"aggregate_graph_display"));
    private final JButton saveGraph = new JButton(JMeterUtils.getResString((String)"aggregate_graph_save"));
    private final JCheckBox samplerSelection = new JCheckBox(JMeterUtils.getResString((String)"graph_resp_time_series_selection"), false);
    private final JTextField samplerMatchLabel = new JTextField();
    private final JButton applyFilterBtn = new JButton(JMeterUtils.getResString((String)"graph_apply_filter"));
    private final JCheckBox caseChkBox = new JCheckBox(JMeterUtils.getResString((String)"search_text_chkbox_case"), false);
    private final JCheckBox regexpChkBox = new JCheckBox(JMeterUtils.getResString((String)"search_text_chkbox_regexp"), true);
    private final JComboBox<String> titleFontNameList = new JComboBox<String>(this.keys(StatGraphProperties.getFontNameMap()));
    private final JComboBox<String> titleFontSizeList = new JComboBox<String>(StatGraphProperties.getFontSize());
    private final JComboBox<String> titleFontStyleList = new JComboBox<String>(this.keys(StatGraphProperties.getFontStyleMap()));
    private final JComboBox<String> fontNameList = new JComboBox<String>(this.keys(StatGraphProperties.getFontNameMap()));
    private final JComboBox<String> fontSizeList = new JComboBox<String>(StatGraphProperties.getFontSize());
    private final JComboBox<String> fontStyleList = new JComboBox<String>(this.keys(StatGraphProperties.getFontStyleMap()));
    private final JComboBox<String> legendPlacementList = new JComboBox<String>(this.keys(StatGraphProperties.getPlacementNameMap()));
    private final JComboBox<String> pointShapeLine = new JComboBox<String>(this.keys(StatGraphProperties.getPointShapeMap()));
    private final JComboBox<String> strokeWidthList = new JComboBox<String>(StatGraphProperties.getStrokeWidth());
    private final JCheckBox numberShowGrouping = new JCheckBox(JMeterUtils.getResString((String)"aggregate_graph_number_grouping"), true);
    private final JButton syncWithName = new JButton(JMeterUtils.getResString((String)"aggregate_graph_sync_with_name"));
    private final JLabeledTextField graphTitle = new JLabeledTextField(JMeterUtils.getResString((String)"graph_resp_time_title_label"));
    private final JLabeledTextField xAxisTimeFormat = new JLabeledTextField(JMeterUtils.getResString((String)"graph_resp_time_xaxis_time_format"), 10);
    private final JLabeledTextField maxValueYAxisLabel = new JLabeledTextField(JMeterUtils.getResString((String)"aggregate_graph_yaxis_max_value"), 5);
    private final JCheckBox dynamicGraphSize = new JCheckBox(JMeterUtils.getResString((String)"aggregate_graph_dynamic_size"));
    private final JLabeledTextField graphWidth = new JLabeledTextField(JMeterUtils.getResString((String)"aggregate_graph_width"), 6);
    private final JLabeledTextField graphHeight = new JLabeledTextField(JMeterUtils.getResString((String)"aggregate_graph_height"), 6);
    private final JLabeledTextField incrScaleYAxis = new JLabeledTextField(JMeterUtils.getResString((String)"aggregate_graph_increment_scale"), 5);
    private long minStartTime = Long.MAX_VALUE;
    private long maxStartTime = Long.MIN_VALUE;
    private final Map<String, RespTimeGraphLineBean> seriesNames = new LinkedHashMap<String, RespTimeGraphLineBean>();
    private final Map<String, Map<Long, StatCalculatorLong>> pList = new LinkedHashMap<String, Map<Long, StatCalculatorLong>>();
    private long durationTest = 0L;
    private int colorIdx = 0;
    private Pattern pattern = null;
    private final List<Color> listColors = Colors.getColors();
    private final List<RespTimeGraphDataBean> internalList = new ArrayList<RespTimeGraphDataBean>();

    public RespTimeGraphVisualizer() {
        this.init();
    }

    private String[] keys(Map<String, ?> map) {
        return map.keySet().toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(SampleResult sampleResult) {
        String sampleLabel = sampleResult.getSampleLabel();
        Object object = this.lockInterval;
        synchronized (object) {
            this.internalList.add(new RespTimeGraphDataBean(sampleResult.getStartTime(), sampleResult.getTime(), sampleLabel));
        }
        Matcher matcher = null;
        if (this.samplerSelection.isSelected() && this.pattern != null) {
            matcher = this.pattern.matcher(sampleLabel);
        }
        if (matcher == null || matcher.find()) {
            long startTimeMS = sampleResult.getStartTime();
            long startTimeInterval = startTimeMS / (long)this.intervalValue;
            JMeterUtils.runSafe((boolean)false, () -> {
                Object object = this.lock;
                synchronized (object) {
                    if (startTimeInterval < this.minStartTime) {
                        this.minStartTime = startTimeInterval;
                    } else if (startTimeInterval > this.maxStartTime) {
                        this.maxStartTime = startTimeInterval;
                    }
                    if (!this.seriesNames.containsKey(sampleLabel)) {
                        this.seriesNames.put(sampleLabel, new RespTimeGraphLineBean(sampleLabel, this.listColors.get(this.colorIdx++)));
                        if (this.colorIdx >= this.listColors.size()) {
                            this.colorIdx = 0;
                        }
                    }
                    Map<Long, StatCalculatorLong> subList = this.pList.get(sampleLabel);
                    Long startTimeIntervalLong = startTimeInterval;
                    if (subList != null) {
                        long respTime = sampleResult.getTime();
                        StatCalculatorLong value = subList.get(startTimeIntervalLong);
                        if (value == null) {
                            value = new StatCalculatorLong();
                            subList.put(startTimeIntervalLong, value);
                        }
                        value.addValue(respTime, 1);
                    } else {
                        LinkedHashMap<Long, StatCalculatorLong> newSubList = new LinkedHashMap<Long, StatCalculatorLong>(5);
                        StatCalculatorLong helper = new StatCalculatorLong();
                        helper.addValue((Number)sampleResult.getTime(), 1L);
                        newSubList.put(startTimeIntervalLong, helper);
                        this.pList.put(sampleLabel, newSubList);
                    }
                }
            });
        }
    }

    public void makeGraph() {
        String yAxisStr;
        Dimension size = this.graphPanel.getSize();
        int width = (int)size.getWidth();
        int height = (int)size.getHeight();
        if (!this.dynamicGraphSize.isSelected()) {
            String wstr = this.graphWidth.getText();
            String hstr = this.graphHeight.getText();
            if (wstr.length() != 0) {
                width = Integer.parseInt(wstr);
            }
            if (hstr.length() != 0) {
                height = Integer.parseInt(hstr);
            }
        }
        int maxYAxisScale = (yAxisStr = this.maxValueYAxisLabel.getText()).length() == 0 ? 0 : Integer.parseInt(yAxisStr);
        this.graphPanel.setData(this.getData());
        this.graphPanel.setTitle(this.graphTitle.getText());
        this.graphPanel.setMaxYAxisScale(maxYAxisScale);
        this.graphPanel.setYAxisLabels(Y_AXIS_LABEL);
        this.graphPanel.setYAxisTitle(Y_AXIS_TITLE);
        this.graphPanel.setXAxisLabels(this.getXAxisLabels());
        this.graphPanel.setLegendLabels(this.getLegendLabels());
        this.graphPanel.setColor(this.getLinesColors());
        this.graphPanel.setShowGrouping(this.numberShowGrouping.isSelected());
        this.graphPanel.setLegendPlacement(StatGraphProperties.getPlacementNameMap().get(this.legendPlacementList.getSelectedItem()));
        this.graphPanel.setPointShape(StatGraphProperties.getPointShapeMap().get(this.pointShapeLine.getSelectedItem()));
        this.graphPanel.setStrokeWidth(Float.parseFloat((String)this.strokeWidthList.getSelectedItem()));
        this.graphPanel.setTitleFont(new Font(StatGraphProperties.getFontNameMap().get(this.titleFontNameList.getSelectedItem()), (int)StatGraphProperties.getFontStyleMap().get(this.titleFontStyleList.getSelectedItem()), Integer.parseInt((String)this.titleFontSizeList.getSelectedItem())));
        this.graphPanel.setLegendFont(new Font(StatGraphProperties.getFontNameMap().get(this.fontNameList.getSelectedItem()), (int)StatGraphProperties.getFontStyleMap().get(this.fontStyleList.getSelectedItem()), Integer.parseInt((String)this.fontSizeList.getSelectedItem())));
        this.graphPanel.setHeight(height);
        this.graphPanel.setWidth(width);
        this.graphPanel.setIncrYAxisScale(this.getIncrScaleYAxis());
        this.graphPanel.repaint();
    }

    public double[][] getData() {
        int size = this.pList.size();
        int max = (int)this.durationTest;
        double[][] data = new double[size][max];
        double nanLast = 0.0;
        double nanBegin = 0.0;
        ArrayList<Double> nanList = new ArrayList<Double>();
        int s = 0;
        for (Map<Long, StatCalculatorLong> subList : this.pList.values()) {
            int idx = 0;
            while ((long)idx < this.durationTest) {
                long keyShift = this.minStartTime + (long)idx;
                StatCalculatorLong value = subList.get(keyShift);
                if (value != null) {
                    data[s][idx] = nanLast = value.getMean();
                    int nlsize = nanList.size();
                    if (nlsize > 0) {
                        double valPrev = nanBegin;
                        for (int cnt = 0; cnt < nlsize; ++cnt) {
                            int pos = idx - (nlsize - cnt);
                            if (pos < 0) {
                                pos = 0;
                            }
                            data[s][pos] = valPrev += (nanLast - nanBegin) / (double)(nlsize + 2);
                        }
                        nanList.clear();
                    }
                } else {
                    nanList.add(Double.NaN);
                    nanBegin = nanLast;
                    data[s][idx] = Double.NaN;
                }
                ++idx;
            }
            ++s;
        }
        return data;
    }

    public String getLabelResource() {
        return "graph_resp_time_title";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearData() {
        Object object = this.lock;
        synchronized (object) {
            this.internalList.clear();
            this.seriesNames.clear();
            this.pList.clear();
            this.minStartTime = Long.MAX_VALUE;
            this.maxStartTime = Long.MIN_VALUE;
            this.durationTest = 0L;
            this.colorIdx = 0;
        }
        this.tabbedGraph.setSelectedIndex(0);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        EmptyBorder margin2 = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.makeTitlePanel());
        VerticalPanel settingsPane = new VerticalPanel();
        settingsPane.setBorder(margin2);
        this.graphPanel = new RespTimeGraphChart();
        this.graphPanel.setPreferredSize(new Dimension(400, 300));
        settingsPane.add(this.createGraphActionsPane());
        settingsPane.add(this.createGraphSettingsPane());
        settingsPane.add(this.createGraphTitlePane());
        settingsPane.add(this.createLinePane());
        settingsPane.add(this.createGraphDimensionPane());
        JPanel axisPane = new JPanel(new BorderLayout());
        axisPane.add((Component)this.createGraphXAxisPane(), "West");
        axisPane.add((Component)this.createGraphYAxisPane(), "Center");
        settingsPane.add(axisPane);
        settingsPane.add(this.createLegendPane());
        this.tabbedGraph.addTab(JMeterUtils.getResString((String)"aggregate_graph_tab_settings"), (Component)settingsPane);
        this.tabbedGraph.addTab(JMeterUtils.getResString((String)"aggregate_graph_tab_graph"), this.graphPanel);
        ChangeListener changeListener = changeEvent -> {
            int index;
            JTabbedPane srcTab = (JTabbedPane)changeEvent.getSource();
            if (srcTab.getTitleAt(index = srcTab.getSelectedIndex()).equals(JMeterUtils.getResString((String)"aggregate_graph_tab_graph"))) {
                this.actionMakeGraph();
            }
        };
        this.tabbedGraph.addChangeListener(changeListener);
        this.add(mainPanel, "North");
        this.add(this.tabbedGraph, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        boolean forceReloadData = false;
        Object eventSource = event.getSource();
        if (eventSource == this.displayButton) {
            this.actionMakeGraph();
        } else if (eventSource == this.saveGraph) {
            this.saveGraphToFile = true;
            try {
                ActionRouter.getInstance().getAction("save_graphics", SaveGraphics.class.getName()).doAction(new ActionEvent(this, event.getID(), "save_graphics"));
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        } else if (eventSource == this.syncWithName) {
            this.graphTitle.setText(this.getName());
        } else if (eventSource == this.dynamicGraphSize) {
            this.enableDynamicGraph(this.dynamicGraphSize.isSelected());
        } else if (eventSource == this.samplerSelection) {
            this.enableSamplerSelection(this.samplerSelection.isSelected());
            if (!this.samplerSelection.isSelected()) {
                forceReloadData = true;
            }
        }
        if (eventSource == this.applyFilterBtn || eventSource == this.intervalButton || forceReloadData) {
            if (eventSource == this.intervalButton) {
                this.intervalValue = Integer.parseInt(this.intervalField.getText());
            }
            if (eventSource == this.applyFilterBtn && this.samplerSelection.isSelected() && this.samplerMatchLabel.getText() != null && this.samplerMatchLabel.getText().length() > 0) {
                this.pattern = this.createPattern(this.samplerMatchLabel.getText());
            } else if (forceReloadData) {
                this.pattern = null;
            }
            if (this.getFile() != null && this.getFile().length() > 0) {
                this.clearData();
                FilePanel filePanel = (FilePanel)this.getFilePanel();
                filePanel.actionPerformed(event);
            } else {
                Object object = this.lockInterval;
                synchronized (object) {
                    if (this.internalList.size() >= 2) {
                        ArrayList<RespTimeGraphDataBean> tempList = new ArrayList<RespTimeGraphDataBean>();
                        tempList.addAll(this.internalList);
                        this.clearData();
                        for (RespTimeGraphDataBean data : tempList) {
                            SampleResult sr = new SampleResult(data.getStartTime(), data.getTime());
                            sr.setSampleLabel(data.getSamplerLabel());
                            this.add(sr);
                        }
                    }
                }
            }
        }
    }

    private void actionMakeGraph() {
        String msgErr = null;
        this.durationTest = this.maxStartTime - this.minStartTime;
        if (this.seriesNames.size() <= 0) {
            msgErr = JMeterUtils.getResString((String)"aggregate_graph_no_values_to_graph");
        } else if (this.durationTest < 1L) {
            msgErr = JMeterUtils.getResString((String)"graph_resp_time_not_enough_data");
        }
        if (msgErr == null) {
            this.makeGraph();
            this.tabbedGraph.setSelectedIndex(1);
        } else {
            this.tabbedGraph.setSelectedIndex(0);
            JOptionPane.showMessageDialog(null, msgErr, msgErr, 2);
        }
    }

    public JComponent getPrintableComponent() {
        if (this.saveGraphToFile) {
            this.saveGraphToFile = false;
            if (this.getData().length > 0 && this.getData()[0].length > 0) {
                this.makeGraph();
            }
            this.graphPanel.setBounds(this.graphPanel.getLocation().x, this.graphPanel.getLocation().y, this.graphPanel.width, this.graphPanel.height);
            return this.graphPanel;
        }
        return this;
    }

    public void configure(TestElement te) {
        super.configure(te);
        this.intervalField.setText(te.getPropertyAsString(INTERVAL, String.valueOf(10000)));
        this.samplerSelection.setSelected(te.getPropertyAsBoolean(SERIES_SELECTION, false));
        this.samplerMatchLabel.setText(te.getPropertyAsString(SERIES_SELECTION_MATCH_LABEL, ""));
        this.caseChkBox.setSelected(te.getPropertyAsBoolean(SERIES_SELECTION_CASE_SENSITIVE, false));
        this.regexpChkBox.setSelected(te.getPropertyAsBoolean(SERIES_SELECTION_REGEXP, true));
        this.graphTitle.setText(te.getPropertyAsString(GRAPH_TITLE, ""));
        this.titleFontNameList.setSelectedIndex(te.getPropertyAsInt(GRAPH_TITLE_FONT_NAME, 0));
        this.titleFontSizeList.setSelectedIndex(te.getPropertyAsInt(GRAPH_TITLE_FONT_SIZE, 6));
        this.titleFontStyleList.setSelectedIndex(te.getPropertyAsInt(GRAPH_TITLE_FONT_STYLE, 1));
        this.strokeWidthList.setSelectedIndex(te.getPropertyAsInt(LINE_STROKE_WIDTH, 4));
        this.pointShapeLine.setSelectedIndex(te.getPropertyAsInt(LINE_SHAPE_POINT, 0));
        this.dynamicGraphSize.setSelected(te.getPropertyAsBoolean(GRAPH_SIZE_DYNAMIC, true));
        this.graphWidth.setText(te.getPropertyAsString(GRAPH_SIZE_WIDTH, ""));
        this.graphHeight.setText(te.getPropertyAsString(GRAPH_SIZE_HEIGHT, ""));
        this.xAxisTimeFormat.setText(te.getPropertyAsString(XAXIS_TIME_FORMAT, DEFAULT_XAXIS_TIME_FORMAT));
        this.maxValueYAxisLabel.setText(te.getPropertyAsString(YAXIS_SCALE_MAX_VALUE, ""));
        this.incrScaleYAxis.setText(te.getPropertyAsString(YAXIS_INCREMENT_SCALE, ""));
        this.numberShowGrouping.setSelected(te.getPropertyAsBoolean(YAXIS_NUMBER_GROUPING, true));
        this.legendPlacementList.setSelectedIndex(te.getPropertyAsInt(LEGEND_PLACEMENT, 0));
        this.fontNameList.setSelectedIndex(te.getPropertyAsInt(LEGEND_FONT, 0));
        this.fontSizeList.setSelectedIndex(te.getPropertyAsInt(LEGEND_SIZE, 2));
        this.fontStyleList.setSelectedIndex(te.getPropertyAsInt(LEGEND_STYLE, 0));
        this.enableSamplerSelection(this.samplerSelection.isSelected());
        this.enableDynamicGraph(this.dynamicGraphSize.isSelected());
    }

    public void modifyTestElement(TestElement te) {
        super.modifyTestElement(te);
        te.setProperty(INTERVAL, this.intervalField.getText(), String.valueOf(10000));
        te.setProperty(SERIES_SELECTION, this.samplerSelection.isSelected(), false);
        te.setProperty(SERIES_SELECTION_MATCH_LABEL, this.samplerMatchLabel.getText(), "");
        te.setProperty(SERIES_SELECTION_CASE_SENSITIVE, this.caseChkBox.isSelected(), false);
        te.setProperty(SERIES_SELECTION_REGEXP, this.regexpChkBox.isSelected(), true);
        te.setProperty(GRAPH_TITLE, this.graphTitle.getText(), "");
        te.setProperty(GRAPH_TITLE_FONT_NAME, this.titleFontNameList.getSelectedIndex(), 0);
        te.setProperty(GRAPH_TITLE_FONT_SIZE, this.titleFontSizeList.getSelectedIndex(), 6);
        te.setProperty(GRAPH_TITLE_FONT_STYLE, this.titleFontStyleList.getSelectedIndex(), 1);
        te.setProperty(LINE_STROKE_WIDTH, this.strokeWidthList.getSelectedIndex(), 4);
        te.setProperty(LINE_SHAPE_POINT, this.pointShapeLine.getSelectedIndex(), 0);
        te.setProperty(GRAPH_SIZE_DYNAMIC, this.dynamicGraphSize.isSelected(), true);
        te.setProperty(GRAPH_SIZE_WIDTH, this.graphWidth.getText(), "");
        te.setProperty(GRAPH_SIZE_HEIGHT, this.graphHeight.getText(), "");
        te.setProperty(XAXIS_TIME_FORMAT, this.xAxisTimeFormat.getText(), DEFAULT_XAXIS_TIME_FORMAT);
        te.setProperty(YAXIS_SCALE_MAX_VALUE, this.maxValueYAxisLabel.getText(), "");
        te.setProperty(YAXIS_INCREMENT_SCALE, this.incrScaleYAxis.getText(), "");
        te.setProperty(YAXIS_NUMBER_GROUPING, this.numberShowGrouping.isSelected(), true);
        te.setProperty(LEGEND_PLACEMENT, this.legendPlacementList.getSelectedIndex(), 0);
        te.setProperty(LEGEND_FONT, this.fontNameList.getSelectedIndex(), 0);
        te.setProperty(LEGEND_SIZE, this.fontSizeList.getSelectedIndex(), 2);
        te.setProperty(LEGEND_STYLE, this.fontStyleList.getSelectedIndex(), 0);
        this.enableSamplerSelection(this.samplerSelection.isSelected());
        this.enableDynamicGraph(this.dynamicGraphSize.isSelected());
    }

    public void clearGui() {
        super.clearGui();
        this.intervalField.setText(String.valueOf(10000));
        this.samplerSelection.setSelected(false);
        this.samplerMatchLabel.setText("");
        this.caseChkBox.setSelected(false);
        this.regexpChkBox.setSelected(true);
        this.graphTitle.setText("");
        this.titleFontNameList.setSelectedIndex(0);
        this.titleFontSizeList.setSelectedIndex(6);
        this.titleFontStyleList.setSelectedIndex(1);
        this.strokeWidthList.setSelectedIndex(4);
        this.pointShapeLine.setSelectedIndex(0);
        this.dynamicGraphSize.setSelected(true);
        this.graphWidth.setText("");
        this.graphHeight.setText("");
        this.xAxisTimeFormat.setText(DEFAULT_XAXIS_TIME_FORMAT);
        this.maxValueYAxisLabel.setText("");
        this.incrScaleYAxis.setText("");
        this.numberShowGrouping.setSelected(true);
        this.legendPlacementList.setSelectedIndex(0);
        this.fontNameList.setSelectedIndex(0);
        this.fontSizeList.setSelectedIndex(2);
        this.fontStyleList.setSelectedIndex(0);
    }

    private JPanel createGraphActionsPane() {
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JPanel displayPane = new JPanel();
        displayPane.add(this.displayButton);
        this.displayButton.addActionListener(this);
        buttonPanel.add((Component)displayPane, "West");
        JPanel savePane = new JPanel();
        savePane.add(this.saveGraph);
        this.saveGraph.addActionListener(this);
        this.syncWithName.addActionListener(this);
        buttonPanel.add((Component)savePane, "East");
        return buttonPanel;
    }

    public String[] getXAxisLabels() {
        SimpleDateFormat formatter = new SimpleDateFormat(this.xAxisTimeFormat.getText());
        String[] xAxisLabels = new String[(int)this.durationTest];
        int j = 0;
        while ((long)j < this.durationTest) {
            xAxisLabels[j] = formatter.format(new Date((this.minStartTime + (long)j) * (long)this.intervalValue));
            ++j;
        }
        return xAxisLabels;
    }

    private String[] getLegendLabels() {
        String[] legends = new String[this.seriesNames.size()];
        int i = 0;
        for (Map.Entry<String, RespTimeGraphLineBean> entry : this.seriesNames.entrySet()) {
            RespTimeGraphLineBean val = entry.getValue();
            legends[i] = val.getLabel();
            ++i;
        }
        return legends;
    }

    private Color[] getLinesColors() {
        Color[] linesColors = new Color[this.seriesNames.size()];
        int i = 0;
        for (Map.Entry<String, RespTimeGraphLineBean> entry : this.seriesNames.entrySet()) {
            RespTimeGraphLineBean val = entry.getValue();
            linesColors[i] = val.getLineColor();
            ++i;
        }
        return linesColors;
    }

    private int getIncrScaleYAxis() {
        int incrYAxisScale = 0;
        String iyas = this.incrScaleYAxis.getText();
        if (iyas.length() != 0) {
            incrYAxisScale = Integer.parseInt(iyas);
        }
        return incrYAxisScale;
    }

    private JPanel createGraphSettingsPane() {
        JPanel settingsPane = new JPanel(new BorderLayout());
        settingsPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"graph_resp_time_settings_pane")));
        JPanel intervalPane = new JPanel();
        intervalPane.setLayout(new FlowLayout(0, 0, 0));
        this.intervalField.setText(String.valueOf(10000));
        intervalPane.add((Component)this.intervalField);
        this.intervalButton.setFont(FONT_SMALL);
        this.intervalButton.addActionListener(this);
        intervalPane.add(this.intervalButton);
        settingsPane.add((Component)intervalPane, "North");
        settingsPane.add((Component)this.createGraphSelectionSubPane(), "South");
        return settingsPane;
    }

    private JPanel createGraphSelectionSubPane() {
        JPanel searchPanel = new JPanel();
        searchPanel.setLayout(new BoxLayout(searchPanel, 0));
        searchPanel.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
        searchPanel.add(this.samplerSelection);
        this.samplerMatchLabel.setEnabled(false);
        this.applyFilterBtn.setEnabled(false);
        this.caseChkBox.setEnabled(false);
        this.regexpChkBox.setEnabled(false);
        this.samplerSelection.addActionListener(this);
        searchPanel.add(this.samplerMatchLabel);
        searchPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.applyFilterBtn.setFont(FONT_SMALL);
        this.applyFilterBtn.addActionListener(this);
        searchPanel.add(this.applyFilterBtn);
        this.caseChkBox.setFont(FONT_SMALL);
        searchPanel.add(this.caseChkBox);
        this.regexpChkBox.setFont(FONT_SMALL);
        searchPanel.add(this.regexpChkBox);
        return searchPanel;
    }

    private JPanel createGraphTitlePane() {
        JPanel titleNamePane = new JPanel(new BorderLayout());
        this.syncWithName.setFont(FONT_SMALL);
        titleNamePane.add((Component)this.graphTitle, "Center");
        titleNamePane.add((Component)this.syncWithName, "East");
        JPanel titleStylePane = new JPanel();
        titleStylePane.setLayout(new FlowLayout(0, 0, 5));
        titleStylePane.add(GuiUtils.createLabelCombo((String)JMeterUtils.getResString((String)"aggregate_graph_font"), this.titleFontNameList));
        this.titleFontNameList.setSelectedIndex(0);
        titleStylePane.add(GuiUtils.createLabelCombo((String)JMeterUtils.getResString((String)"aggregate_graph_size"), this.titleFontSizeList));
        this.titleFontSizeList.setSelectedItem(StatGraphProperties.getFontSize()[6]);
        titleStylePane.add(GuiUtils.createLabelCombo((String)JMeterUtils.getResString((String)"aggregate_graph_style"), this.titleFontStyleList));
        this.titleFontStyleList.setSelectedIndex(1);
        JPanel titlePane = new JPanel(new BorderLayout());
        titlePane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"aggregate_graph_title_group")));
        titlePane.add((Component)titleNamePane, "North");
        titlePane.add((Component)titleStylePane, "South");
        return titlePane;
    }

    private JPanel createLinePane() {
        JPanel lineStylePane = new JPanel();
        lineStylePane.setLayout(new FlowLayout(0, 0, 0));
        lineStylePane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"graph_resp_time_settings_line")));
        lineStylePane.add(GuiUtils.createLabelCombo((String)JMeterUtils.getResString((String)"graph_resp_time_stroke_width"), this.strokeWidthList));
        this.strokeWidthList.setSelectedItem(StatGraphProperties.getStrokeWidth()[4]);
        lineStylePane.add(GuiUtils.createLabelCombo((String)JMeterUtils.getResString((String)"graph_resp_time_shape_label"), this.pointShapeLine));
        this.pointShapeLine.setSelectedIndex(0);
        return lineStylePane;
    }

    private JPanel createGraphDimensionPane() {
        JPanel dimensionPane = new JPanel();
        dimensionPane.setLayout(new FlowLayout(0, 0, 0));
        dimensionPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"aggregate_graph_dimension")));
        dimensionPane.add(this.dynamicGraphSize);
        this.dynamicGraphSize.setSelected(true);
        this.graphWidth.setEnabled(false);
        this.graphHeight.setEnabled(false);
        this.dynamicGraphSize.addActionListener(this);
        dimensionPane.add(Box.createRigidArea(new Dimension(10, 0)));
        dimensionPane.add((Component)this.graphWidth);
        dimensionPane.add(Box.createRigidArea(new Dimension(5, 0)));
        dimensionPane.add((Component)this.graphHeight);
        return dimensionPane;
    }

    private JPanel createGraphXAxisPane() {
        JPanel xAxisPane = new JPanel();
        xAxisPane.setLayout(new FlowLayout(0, 0, 0));
        xAxisPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"aggregate_graph_xaxis_group")));
        this.xAxisTimeFormat.setText(DEFAULT_XAXIS_TIME_FORMAT);
        xAxisPane.add((Component)this.xAxisTimeFormat);
        return xAxisPane;
    }

    private JPanel createGraphYAxisPane() {
        JPanel yAxisPane = new JPanel();
        yAxisPane.setLayout(new FlowLayout(0, 0, 0));
        yAxisPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"aggregate_graph_yaxis_group")));
        yAxisPane.add((Component)this.maxValueYAxisLabel);
        yAxisPane.add((Component)this.incrScaleYAxis);
        yAxisPane.add(this.numberShowGrouping);
        return yAxisPane;
    }

    private JPanel createLegendPane() {
        JPanel legendPanel = new JPanel();
        legendPanel.setLayout(new FlowLayout(0, 0, 0));
        legendPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"aggregate_graph_legend")));
        legendPanel.add(GuiUtils.createLabelCombo((String)JMeterUtils.getResString((String)"aggregate_graph_legend_placement"), this.legendPlacementList));
        this.legendPlacementList.setSelectedIndex(0);
        legendPanel.add(GuiUtils.createLabelCombo((String)JMeterUtils.getResString((String)"aggregate_graph_font"), this.fontNameList));
        this.fontNameList.setSelectedIndex(0);
        legendPanel.add(GuiUtils.createLabelCombo((String)JMeterUtils.getResString((String)"aggregate_graph_size"), this.fontSizeList));
        this.fontSizeList.setSelectedItem(StatGraphProperties.getFontSize()[2]);
        legendPanel.add(GuiUtils.createLabelCombo((String)JMeterUtils.getResString((String)"aggregate_graph_style"), this.fontStyleList));
        this.fontStyleList.setSelectedIndex(0);
        return legendPanel;
    }

    private Pattern createPattern(String textToFind) {
        String textToFindQ = Pattern.quote(textToFind);
        if (this.regexpChkBox.isSelected()) {
            textToFindQ = textToFind;
        }
        Pattern pattern = null;
        try {
            pattern = this.caseChkBox.isSelected() ? Pattern.compile(textToFindQ) : Pattern.compile(textToFindQ, 2);
        }
        catch (PatternSyntaxException pse) {
            return null;
        }
        return pattern;
    }

    private void enableDynamicGraph(boolean enable) {
        if (enable) {
            this.graphWidth.setEnabled(false);
            this.graphHeight.setEnabled(false);
        } else {
            this.graphWidth.setEnabled(true);
            this.graphHeight.setEnabled(true);
        }
    }

    private void enableSamplerSelection(boolean enable) {
        if (enable) {
            this.samplerMatchLabel.setEnabled(true);
            this.applyFilterBtn.setEnabled(true);
            this.caseChkBox.setEnabled(true);
            this.regexpChkBox.setEnabled(true);
        } else {
            this.samplerMatchLabel.setEnabled(false);
            this.applyFilterBtn.setEnabled(false);
            this.caseChkBox.setEnabled(false);
            this.regexpChkBox.setEnabled(false);
        }
    }
}

