/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.temporal.ChronoField;
import org.exparity.hamcrest.date.core.TemporalAdapter;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class IsMillisecond<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final int expected;
    private final TemporalAdapter<T> accessor;

    public IsMillisecond(int expected, TemporalAdapter<T> accessor) {
        this.expected = expected;
        this.accessor = accessor;
    }

    protected boolean matchesSafely(T actual, Description mismatchDescription) {
        int actualMillis = this.accessor.asTemporal(actual).get(ChronoField.MILLI_OF_SECOND);
        if (this.expected == actualMillis) {
            return true;
        }
        mismatchDescription.appendText("the date has the millisecond " + actualMillis);
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("the date has the millisecond " + this.expected);
    }
}

