/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core.wrapper;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import org.exparity.hamcrest.date.core.TemporalWrapper;

public class ZonedDateTimeWrapper
implements TemporalWrapper<ZonedDateTime> {
    private final ZonedDateTime wrapped;
    private final TemporalUnit accuracy;

    public ZonedDateTimeWrapper(Date date, ZoneId zone) {
        this.wrapped = date.toInstant().atZone(zone);
        this.accuracy = ChronoUnit.MILLIS;
    }

    public ZonedDateTimeWrapper(ZonedDateTime date) {
        this.accuracy = ChronoUnit.NANOS;
        this.wrapped = date;
    }

    public ZonedDateTimeWrapper(LocalDateTime date, ZoneId zone) {
        this.wrapped = ZonedDateTime.of(date, zone);
        this.accuracy = ChronoUnit.NANOS;
    }

    public ZonedDateTimeWrapper(int year, Month month, int dayOfMonth, int hour, int minute, int second, ZoneId zone) {
        this.wrapped = ZonedDateTime.of(LocalDateTime.of(year, month, dayOfMonth, hour, minute, second), zone);
        this.accuracy = ChronoUnit.SECONDS;
    }

    public ZonedDateTimeWrapper(int year, Month month, int dayOfMonth, int hour, int minute, int second, int nanos, ZoneId zone) {
        this.wrapped = ZonedDateTime.of(LocalDateTime.of(year, month, dayOfMonth, hour, minute, second, nanos), zone);
        this.accuracy = ChronoUnit.NANOS;
    }

    public ZonedDateTimeWrapper(int year, Month month, int dayOfMonth, ZoneId zone) {
        this.wrapped = ZonedDateTime.of(LocalDate.of(year, month, dayOfMonth), LocalTime.NOON, zone);
        this.accuracy = ChronoUnit.DAYS;
    }

    @Override
    public long difference(ZonedDateTime other, ChronoUnit unit) {
        return Math.abs(this.wrapped.truncatedTo(this.accuracy).until(other, unit));
    }

    @Override
    public boolean isAfter(ZonedDateTime other) {
        return this.wrapped.truncatedTo(this.accuracy).isAfter(other.truncatedTo(this.accuracy));
    }

    @Override
    public boolean isBefore(ZonedDateTime other) {
        return this.wrapped.truncatedTo(this.accuracy).isBefore(other.truncatedTo(this.accuracy));
    }

    @Override
    public boolean isSame(ZonedDateTime other) {
        return this.wrapped.truncatedTo(this.accuracy).isEqual(other.truncatedTo(this.accuracy));
    }

    @Override
    public boolean isSameDay(ZonedDateTime other) {
        return this.wrapped.toLocalDate().isEqual(other.toLocalDate());
    }

    @Override
    public ZonedDateTime unwrap() {
        return this.wrapped;
    }
}

