/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.DarculaUIUtil;
import com.bulenkov.iconloader.util.EmptyIcon;
import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.Gray;
import com.bulenkov.iconloader.util.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.metal.MetalCheckBoxUI;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class DarculaCheckBoxUI
extends MetalCheckBoxUI {
    public static ComponentUI createUI(JComponent c) {
        if (UIUtil.getParentOfType(CellRendererPane.class, c) != null) {
            c.setBorder(null);
        }
        return new DarculaCheckBoxUI();
    }

    @Override
    public synchronized void paint(Graphics g2d, JComponent c) {
        Graphics2D g = (Graphics2D)g2d;
        JCheckBox b = (JCheckBox)c;
        ButtonModel model = b.getModel();
        Dimension size = c.getSize();
        Font font = c.getFont();
        g.setFont(font);
        FontMetrics fm = SwingUtilities2.getFontMetrics(c, g, font);
        Rectangle viewRect = new Rectangle(size);
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Insets i = c.getInsets();
        viewRect.x += i.left;
        viewRect.y += i.top;
        viewRect.width -= i.right + viewRect.x;
        viewRect.height -= i.bottom + viewRect.y;
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), this.getDefaultIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getIconTextGap());
        if (c.isOpaque()) {
            g.setColor(b.getBackground());
            g.fillRect(0, 0, size.width, size.height);
        }
        if (b.isSelected() && b.getSelectedIcon() != null) {
            b.getSelectedIcon().paintIcon(b, g, iconRect.x + 4, iconRect.y + 2);
        } else if (!b.isSelected() && b.getIcon() != null) {
            b.getIcon().paintIcon(b, g, iconRect.x + 4, iconRect.y + 2);
        } else {
            int x = iconRect.x + 3;
            int y = iconRect.y + 3;
            int w = iconRect.width - 6;
            int h = iconRect.height - 6;
            g.translate(x, y);
            GradientPaint paint = new GradientPaint(w / 2, 0.0f, b.getBackground().brighter(), w / 2, h, b.getBackground());
            g.setPaint(paint);
            g.fillRect(1, 1, w - 2, h - 2);
            GraphicsConfig config = new GraphicsConfig(g);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
            boolean armed = b.getModel().isArmed();
            if (c.hasFocus()) {
                g.setPaint(new GradientPaint(w / 2, 1.0f, this.getFocusedBackgroundColor1(armed), w / 2, h, this.getFocusedBackgroundColor2(armed)));
                g.fillRoundRect(0, 0, w - 2, h - 2, 4, 4);
                DarculaUIUtil.paintFocusRing(g, 1, 1, w - 2, h - 2);
            } else {
                g.setPaint(new GradientPaint(w / 2, 1.0f, this.getBackgroundColor1(), w / 2, h, this.getBackgroundColor2()));
                g.fillRoundRect(0, 0, w, h - 1, 4, 4);
                g.setPaint(new GradientPaint(w / 2, 1.0f, this.getBorderColor1(b.isEnabled()), w / 2, h, this.getBorderColor2(b.isEnabled())));
                g.drawRoundRect(0, UIUtil.isUnderDarcula() ? 1 : 0, w, h - 1, 4, 4);
                g.setPaint(this.getInactiveFillColor());
                g.drawRoundRect(0, 0, w, h - 1, 4, 4);
            }
            if (b.getModel().isSelected()) {
                g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                g.setStroke(new BasicStroke(2.0f, 1, 1));
                g.setPaint(this.getShadowColor(b.isEnabled()));
                g.drawLine(4, 7, 7, 11);
                g.drawLine(7, 11, w, 2);
                g.setPaint(this.getCheckSignColor(b.isEnabled()));
                g.drawLine(4, 5, 7, 9);
                g.drawLine(7, 9, w, 0);
            }
            g.translate(-x, -y);
            config.restore();
        }
        if (text != null) {
            View view = (View)c.getClientProperty("html");
            if (view != null) {
                view.paint(g, textRect);
            } else {
                g.setColor(model.isEnabled() ? b.getForeground() : this.getDisabledTextColor());
                SwingUtilities2.drawStringUnderlineCharAt(c, g, text, b.getDisplayedMnemonicIndex(), textRect.x, textRect.y + fm.getAscent());
            }
        }
    }

    protected Color getInactiveFillColor() {
        return DarculaCheckBoxUI.getColor("inactiveFillColor", Gray._40.withAlpha(180));
    }

    protected Color getBorderColor1(boolean enabled) {
        return enabled ? DarculaCheckBoxUI.getColor("borderColor1", Gray._120.withAlpha(90)) : DarculaCheckBoxUI.getColor("disabledBorderColor1", Gray._120.withAlpha(90));
    }

    protected Color getBorderColor2(boolean enabled) {
        return enabled ? DarculaCheckBoxUI.getColor("borderColor2", Gray._105.withAlpha(90)) : DarculaCheckBoxUI.getColor("disabledBorderColor2", Gray._105.withAlpha(90));
    }

    protected Color getBackgroundColor1() {
        return DarculaCheckBoxUI.getColor("backgroundColor1", Gray._110);
    }

    protected Color getBackgroundColor2() {
        return DarculaCheckBoxUI.getColor("backgroundColor2", Gray._95);
    }

    protected Color getCheckSignColor(boolean enabled) {
        return enabled ? DarculaCheckBoxUI.getColor("checkSignColor", Gray._170) : DarculaCheckBoxUI.getColor("checkSignColorDisabled", Gray._120);
    }

    protected Color getShadowColor(boolean enabled) {
        return enabled ? DarculaCheckBoxUI.getColor("shadowColor", Gray._30) : DarculaCheckBoxUI.getColor("shadowColorDisabled", Gray._60);
    }

    protected Color getFocusedBackgroundColor1(boolean armed) {
        return armed ? DarculaCheckBoxUI.getColor("focusedArmed.backgroundColor1", Gray._100) : DarculaCheckBoxUI.getColor("focused.backgroundColor1", Gray._120);
    }

    protected Color getFocusedBackgroundColor2(boolean armed) {
        return armed ? DarculaCheckBoxUI.getColor("focusedArmed.backgroundColor2", Gray._55) : DarculaCheckBoxUI.getColor("focused.backgroundColor2", Gray._75);
    }

    protected static Color getColor(String shortPropertyName, Color defaultValue) {
        Color color = UIManager.getColor("CheckBox.darcula." + shortPropertyName);
        return color == null ? defaultValue : color;
    }

    @Override
    public Icon getDefaultIcon() {
        return new IconUIResource(EmptyIcon.create(20));
    }
}

