/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.configuration.spring.security;

import com.mindskip.xzs.domain.enums.RoleEnum;
import com.mindskip.xzs.service.UserService;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;

@Component
public class RestDetailsServiceImpl
implements UserDetailsService {
    private final UserService userService;

    @Autowired
    public RestDetailsServiceImpl(UserService userService) {
        this.userService = userService;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        com.mindskip.xzs.domain.User user = this.userService.getUserByUserName(username);
        if (user == null) {
            throw new UsernameNotFoundException("Username  not found.");
        }
        ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
        grantedAuthorities.add(new SimpleGrantedAuthority(RoleEnum.fromCode((Integer)user.getRole()).getRoleName()));
        return new User(user.getUserName(), user.getPassword(), grantedAuthorities);
    }
}

