/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.configuration.spring.security;

import com.mindskip.xzs.configuration.property.CookieConfig;
import com.mindskip.xzs.configuration.spring.security.AuthenticationBean;
import com.mindskip.xzs.configuration.spring.security.RestTokenBasedRememberMeServices;
import com.mindskip.xzs.utility.JsonUtil;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class RestLoginAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    private final Logger logger = LoggerFactory.getLogger(RestLoginAuthenticationFilter.class);

    public RestLoginAuthenticationFilter() {
        super((RequestMatcher)new AntPathRequestMatcher("/api/user/login", "POST"));
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        UsernamePasswordAuthenticationToken authRequest;
        try (ServletInputStream is = request.getInputStream();){
            AuthenticationBean authenticationBean = (AuthenticationBean)JsonUtil.toJsonObject((InputStream)is, AuthenticationBean.class);
            request.setAttribute("remember-me", (Object)authenticationBean.isRemember());
            authRequest = new UsernamePasswordAuthenticationToken((Object)authenticationBean.getUserName(), (Object)authenticationBean.getPassword());
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            authRequest = new UsernamePasswordAuthenticationToken((Object)"", (Object)"");
        }
        this.setDetails(request, authRequest);
        return this.getAuthenticationManager().authenticate((Authentication)authRequest);
    }

    void setUserDetailsService(UserDetailsService userDetailsService) {
        RestTokenBasedRememberMeServices tokenBasedRememberMeServices = new RestTokenBasedRememberMeServices(CookieConfig.getName(), userDetailsService);
        tokenBasedRememberMeServices.setTokenValiditySeconds(CookieConfig.getInterval().intValue());
        this.setRememberMeServices((RememberMeServices)tokenBasedRememberMeServices);
    }

    private void setDetails(HttpServletRequest request, UsernamePasswordAuthenticationToken authRequest) {
        authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
    }
}

