/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.controller.admin;

import com.github.pagehelper.PageInfo;
import com.mindskip.xzs.base.BaseApiController;
import com.mindskip.xzs.base.RestResponse;
import com.mindskip.xzs.domain.Subject;
import com.mindskip.xzs.service.SubjectService;
import com.mindskip.xzs.utility.PageInfoHelper;
import com.mindskip.xzs.viewmodel.admin.education.SubjectEditRequestVM;
import com.mindskip.xzs.viewmodel.admin.education.SubjectPageRequestVM;
import com.mindskip.xzs.viewmodel.admin.education.SubjectResponseVM;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="AdminEducationController")
@RequestMapping(value={"/api/admin/education"})
public class EducationController
extends BaseApiController {
    private final SubjectService subjectService;

    @Autowired
    public EducationController(SubjectService subjectService) {
        this.subjectService = subjectService;
    }

    @RequestMapping(value={"/subject/list"}, method={RequestMethod.POST})
    public RestResponse<List<Subject>> list() {
        List subjects = this.subjectService.allSubject();
        return RestResponse.ok((Object)subjects);
    }

    @RequestMapping(value={"/subject/page"}, method={RequestMethod.POST})
    public RestResponse<PageInfo<SubjectResponseVM>> pageList(@RequestBody SubjectPageRequestVM model) {
        PageInfo pageInfo = this.subjectService.page(model);
        PageInfo page = PageInfoHelper.copyMap((PageInfo)pageInfo, e -> (SubjectResponseVM)modelMapper.map(e, SubjectResponseVM.class));
        return RestResponse.ok((Object)page);
    }

    @RequestMapping(value={"/subject/edit"}, method={RequestMethod.POST})
    public RestResponse edit(@RequestBody @Valid SubjectEditRequestVM model) {
        Subject subject = (Subject)modelMapper.map((Object)model, Subject.class);
        if (model.getId() == null) {
            subject.setDeleted(Boolean.valueOf(false));
            this.subjectService.insertByFilter((Object)subject);
        } else {
            this.subjectService.updateByIdFilter((Object)subject);
        }
        return RestResponse.ok();
    }

    @RequestMapping(value={"/subject/select/{id}"}, method={RequestMethod.POST})
    public RestResponse<SubjectEditRequestVM> select(@PathVariable Integer id) {
        Subject subject = (Subject)this.subjectService.selectById(id);
        SubjectEditRequestVM vm = (SubjectEditRequestVM)modelMapper.map((Object)subject, SubjectEditRequestVM.class);
        return RestResponse.ok((Object)vm);
    }

    @RequestMapping(value={"/subject/delete/{id}"}, method={RequestMethod.POST})
    public RestResponse delete(@PathVariable Integer id) {
        Subject subject = (Subject)this.subjectService.selectById(id);
        subject.setDeleted(Boolean.valueOf(true));
        this.subjectService.updateByIdFilter((Object)subject);
        return RestResponse.ok();
    }
}

