/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.controller.admin;

import com.github.pagehelper.PageInfo;
import com.mindskip.xzs.base.BaseApiController;
import com.mindskip.xzs.base.RestResponse;
import com.mindskip.xzs.domain.TaskExam;
import com.mindskip.xzs.service.TaskExamService;
import com.mindskip.xzs.utility.DateTimeUtil;
import com.mindskip.xzs.utility.PageInfoHelper;
import com.mindskip.xzs.viewmodel.admin.task.TaskPageRequestVM;
import com.mindskip.xzs.viewmodel.admin.task.TaskPageResponseVM;
import com.mindskip.xzs.viewmodel.admin.task.TaskRequestVM;
import java.util.Date;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="AdminTaskController")
@RequestMapping(value={"/api/admin/task"})
public class TaskController
extends BaseApiController {
    private final TaskExamService taskExamService;

    @Autowired
    public TaskController(TaskExamService taskExamService) {
        this.taskExamService = taskExamService;
    }

    @RequestMapping(value={"/page"}, method={RequestMethod.POST})
    public RestResponse<PageInfo<TaskPageResponseVM>> pageList(@RequestBody TaskPageRequestVM model) {
        PageInfo pageInfo = this.taskExamService.page(model);
        PageInfo page = PageInfoHelper.copyMap((PageInfo)pageInfo, m -> {
            TaskPageResponseVM vm = (TaskPageResponseVM)modelMapper.map(m, TaskPageResponseVM.class);
            vm.setCreateTime(DateTimeUtil.dateFormat((Date)m.getCreateTime()));
            return vm;
        });
        return RestResponse.ok((Object)page);
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    public RestResponse edit(@RequestBody @Valid TaskRequestVM model) {
        this.taskExamService.edit(model, this.getCurrentUser());
        TaskRequestVM vm = this.taskExamService.taskExamToVM(model.getId());
        return RestResponse.ok((Object)vm);
    }

    @RequestMapping(value={"/select/{id}"}, method={RequestMethod.POST})
    public RestResponse<TaskRequestVM> select(@PathVariable Integer id) {
        TaskRequestVM vm = this.taskExamService.taskExamToVM(id);
        return RestResponse.ok((Object)vm);
    }

    @RequestMapping(value={"/delete/{id}"}, method={RequestMethod.POST})
    public RestResponse delete(@PathVariable Integer id) {
        TaskExam taskExam = (TaskExam)this.taskExamService.selectById(id);
        taskExam.setDeleted(Boolean.valueOf(true));
        this.taskExamService.updateByIdFilter((Object)taskExam);
        return RestResponse.ok();
    }
}

