/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.controller.student;

import com.mindskip.xzs.base.BaseApiController;
import com.mindskip.xzs.base.RestResponse;
import com.mindskip.xzs.domain.Subject;
import com.mindskip.xzs.domain.User;
import com.mindskip.xzs.service.SubjectService;
import com.mindskip.xzs.viewmodel.student.education.SubjectEditRequestVM;
import com.mindskip.xzs.viewmodel.student.education.SubjectVM;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="StudentEducationController")
@RequestMapping(value={"/api/student/education"})
public class EducationController
extends BaseApiController {
    private final SubjectService subjectService;

    @Autowired
    public EducationController(SubjectService subjectService) {
        this.subjectService = subjectService;
    }

    @RequestMapping(value={"/subject/list"}, method={RequestMethod.POST})
    public RestResponse<List<SubjectVM>> list() {
        User user = this.getCurrentUser();
        List subjects = this.subjectService.getSubjectByLevel(user.getUserLevel());
        List subjectVMS = subjects.stream().map(d -> {
            SubjectVM subjectVM = (SubjectVM)modelMapper.map(d, SubjectVM.class);
            subjectVM.setId(String.valueOf(d.getId()));
            return subjectVM;
        }).collect(Collectors.toList());
        return RestResponse.ok(subjectVMS);
    }

    @RequestMapping(value={"/subject/select/{id}"}, method={RequestMethod.POST})
    public RestResponse<SubjectEditRequestVM> select(@PathVariable Integer id) {
        Subject subject = (Subject)this.subjectService.selectById(id);
        SubjectEditRequestVM vm = (SubjectEditRequestVM)modelMapper.map((Object)subject, SubjectEditRequestVM.class);
        return RestResponse.ok((Object)vm);
    }
}

