/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.controller.student;

import com.github.pagehelper.PageInfo;
import com.mindskip.xzs.base.BaseApiController;
import com.mindskip.xzs.base.RestResponse;
import com.mindskip.xzs.domain.ExamPaperAnswer;
import com.mindskip.xzs.domain.ExamPaperAnswerInfo;
import com.mindskip.xzs.domain.Subject;
import com.mindskip.xzs.domain.User;
import com.mindskip.xzs.domain.UserEventLog;
import com.mindskip.xzs.domain.enums.ExamPaperAnswerStatusEnum;
import com.mindskip.xzs.event.CalculateExamPaperAnswerCompleteEvent;
import com.mindskip.xzs.event.UserEvent;
import com.mindskip.xzs.service.ExamPaperAnswerService;
import com.mindskip.xzs.service.ExamPaperService;
import com.mindskip.xzs.service.SubjectService;
import com.mindskip.xzs.utility.DateTimeUtil;
import com.mindskip.xzs.utility.ExamUtil;
import com.mindskip.xzs.utility.PageInfoHelper;
import com.mindskip.xzs.viewmodel.admin.exam.ExamPaperEditRequestVM;
import com.mindskip.xzs.viewmodel.student.exam.ExamPaperReadVM;
import com.mindskip.xzs.viewmodel.student.exam.ExamPaperSubmitVM;
import com.mindskip.xzs.viewmodel.student.exampaper.ExamPaperAnswerPageResponseVM;
import com.mindskip.xzs.viewmodel.student.exampaper.ExamPaperAnswerPageVM;
import java.util.Date;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="StudentExamPaperAnswerController")
@RequestMapping(value={"/api/student/exampaper/answer"})
public class ExamPaperAnswerController
extends BaseApiController {
    private final ExamPaperAnswerService examPaperAnswerService;
    private final ExamPaperService examPaperService;
    private final SubjectService subjectService;
    private final ApplicationEventPublisher eventPublisher;

    @Autowired
    public ExamPaperAnswerController(ExamPaperAnswerService examPaperAnswerService, ExamPaperService examPaperService, SubjectService subjectService, ApplicationEventPublisher eventPublisher) {
        this.examPaperAnswerService = examPaperAnswerService;
        this.examPaperService = examPaperService;
        this.subjectService = subjectService;
        this.eventPublisher = eventPublisher;
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    public RestResponse<PageInfo<ExamPaperAnswerPageResponseVM>> pageList(@RequestBody @Valid ExamPaperAnswerPageVM model) {
        model.setCreateUser(this.getCurrentUser().getId());
        PageInfo pageInfo = this.examPaperAnswerService.studentPage(model);
        PageInfo page = PageInfoHelper.copyMap((PageInfo)pageInfo, e -> {
            ExamPaperAnswerPageResponseVM vm = (ExamPaperAnswerPageResponseVM)modelMapper.map(e, ExamPaperAnswerPageResponseVM.class);
            Subject subject = (Subject)this.subjectService.selectById(vm.getSubjectId());
            vm.setDoTime(ExamUtil.secondToVM((Integer)e.getDoTime()));
            vm.setSystemScore(ExamUtil.scoreToVM((Integer)e.getSystemScore()));
            vm.setUserScore(ExamUtil.scoreToVM((Integer)e.getUserScore()));
            vm.setPaperScore(ExamUtil.scoreToVM((Integer)e.getPaperScore()));
            vm.setSubjectName(subject.getName());
            vm.setCreateTime(DateTimeUtil.dateFormat((Date)e.getCreateTime()));
            return vm;
        });
        return RestResponse.ok((Object)page);
    }

    @RequestMapping(value={"/answerSubmit"}, method={RequestMethod.POST})
    public RestResponse answerSubmit(@RequestBody @Valid ExamPaperSubmitVM examPaperSubmitVM) {
        User user = this.getCurrentUser();
        ExamPaperAnswerInfo examPaperAnswerInfo = this.examPaperAnswerService.calculateExamPaperAnswer(examPaperSubmitVM, user);
        if (null == examPaperAnswerInfo) {
            return RestResponse.fail((Integer)2, (String)"\u8bd5\u5377\u4e0d\u80fd\u91cd\u590d\u505a");
        }
        ExamPaperAnswer examPaperAnswer = examPaperAnswerInfo.getExamPaperAnswer();
        Integer userScore = examPaperAnswer.getUserScore();
        String scoreVm = ExamUtil.scoreToVM((Integer)userScore);
        UserEventLog userEventLog = new UserEventLog(user.getId(), user.getUserName(), user.getRealName(), new Date());
        String content = user.getUserName() + " \u63d0\u4ea4\u8bd5\u5377\uff1a" + examPaperAnswerInfo.getExamPaper().getName() + " \u5f97\u5206\uff1a" + scoreVm + " \u8017\u65f6\uff1a" + ExamUtil.secondToVM((Integer)examPaperAnswer.getDoTime());
        userEventLog.setContent(content);
        this.eventPublisher.publishEvent((ApplicationEvent)new CalculateExamPaperAnswerCompleteEvent(examPaperAnswerInfo));
        this.eventPublisher.publishEvent((ApplicationEvent)new UserEvent(userEventLog));
        return RestResponse.ok((Object)scoreVm);
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    public RestResponse edit(@RequestBody @Valid ExamPaperSubmitVM examPaperSubmitVM) {
        boolean notJudge = examPaperSubmitVM.getAnswerItems().stream().anyMatch(i -> i.getDoRight() == null && i.getScore() == null);
        if (notJudge) {
            return RestResponse.fail((Integer)2, (String)"\u6709\u672a\u6279\u6539\u9898\u76ee");
        }
        ExamPaperAnswer examPaperAnswer = (ExamPaperAnswer)this.examPaperAnswerService.selectById(examPaperSubmitVM.getId());
        ExamPaperAnswerStatusEnum examPaperAnswerStatusEnum = ExamPaperAnswerStatusEnum.fromCode((Integer)examPaperAnswer.getStatus());
        if (examPaperAnswerStatusEnum == ExamPaperAnswerStatusEnum.Complete) {
            return RestResponse.fail((Integer)3, (String)"\u8bd5\u5377\u5df2\u5b8c\u6210");
        }
        String score = this.examPaperAnswerService.judge(examPaperSubmitVM);
        User user = this.getCurrentUser();
        UserEventLog userEventLog = new UserEventLog(user.getId(), user.getUserName(), user.getRealName(), new Date());
        String content = user.getUserName() + " \u6279\u6539\u8bd5\u5377\uff1a" + examPaperAnswer.getPaperName() + " \u5f97\u5206\uff1a" + score;
        userEventLog.setContent(content);
        this.eventPublisher.publishEvent((ApplicationEvent)new UserEvent(userEventLog));
        return RestResponse.ok((Object)score);
    }

    @RequestMapping(value={"/read/{id}"}, method={RequestMethod.POST})
    public RestResponse<ExamPaperReadVM> read(@PathVariable Integer id) {
        ExamPaperAnswer examPaperAnswer = (ExamPaperAnswer)this.examPaperAnswerService.selectById(id);
        ExamPaperReadVM vm = new ExamPaperReadVM();
        ExamPaperEditRequestVM paper = this.examPaperService.examPaperToVM(examPaperAnswer.getExamPaperId());
        ExamPaperSubmitVM answer = this.examPaperAnswerService.examPaperAnswerToVM(examPaperAnswer.getId());
        vm.setPaper(paper);
        vm.setAnswer(answer);
        return RestResponse.ok((Object)vm);
    }
}

