/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.controller.wx.student;

import com.mindskip.xzs.base.RestResponse;
import com.mindskip.xzs.configuration.property.SystemConfig;
import com.mindskip.xzs.controller.wx.BaseWXApiController;
import com.mindskip.xzs.domain.User;
import com.mindskip.xzs.domain.UserToken;
import com.mindskip.xzs.domain.enums.UserStatusEnum;
import com.mindskip.xzs.service.AuthenticationService;
import com.mindskip.xzs.service.UserService;
import com.mindskip.xzs.service.UserTokenService;
import com.mindskip.xzs.utility.WxUtil;
import com.mindskip.xzs.viewmodel.wx.student.user.BindInfo;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="WXStudentAuthController")
@RequestMapping(value={"/api/wx/student/auth"})
@ResponseBody
public class AuthController
extends BaseWXApiController {
    private final SystemConfig systemConfig;
    private final AuthenticationService authenticationService;
    private final UserService userService;
    private final UserTokenService userTokenService;

    @Autowired
    public AuthController(SystemConfig systemConfig, AuthenticationService authenticationService, UserService userService, UserTokenService userTokenService) {
        this.systemConfig = systemConfig;
        this.authenticationService = authenticationService;
        this.userService = userService;
        this.userTokenService = userTokenService;
    }

    @RequestMapping(value={"/bind"}, method={RequestMethod.POST})
    public RestResponse bind(@Valid BindInfo model) {
        User user = this.userService.getUserByUserName(model.getUserName());
        if (user == null) {
            return RestResponse.fail((Integer)2, (String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        }
        boolean result = this.authenticationService.authUser(user, model.getUserName(), model.getPassword());
        if (!result) {
            return RestResponse.fail((Integer)2, (String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        }
        UserStatusEnum userStatusEnum = UserStatusEnum.fromCode((Integer)user.getStatus());
        if (UserStatusEnum.Disable == userStatusEnum) {
            return RestResponse.fail((Integer)3, (String)"\u7528\u6237\u88ab\u7981\u7528");
        }
        String code = model.getCode();
        String openid = WxUtil.getOpenId((String)this.systemConfig.getWx().getAppid(), (String)this.systemConfig.getWx().getSecret(), (String)code);
        if (null == openid) {
            return RestResponse.fail((Integer)4, (String)"\u83b7\u53d6\u5fae\u4fe1OpenId\u5931\u8d25");
        }
        user.setWxOpenId(openid);
        UserToken userToken = this.userTokenService.bind(user);
        return RestResponse.ok((Object)userToken.getToken());
    }

    @RequestMapping(value={"/checkBind"}, method={RequestMethod.POST})
    public RestResponse checkBind(@Valid @NotBlank String code) {
        String openid = WxUtil.getOpenId((String)this.systemConfig.getWx().getAppid(), (String)this.systemConfig.getWx().getSecret(), (String)code);
        if (null == openid) {
            return RestResponse.fail((Integer)3, (String)"\u83b7\u53d6\u5fae\u4fe1OpenId\u5931\u8d25");
        }
        UserToken userToken = this.userTokenService.checkBind(openid);
        if (null != userToken) {
            return RestResponse.ok((Object)userToken.getToken());
        }
        return RestResponse.fail((Integer)2, (String)"\u7528\u6237\u672a\u7ed1\u5b9a");
    }

    @RequestMapping(value={"/unBind"}, method={RequestMethod.POST})
    public RestResponse unBind() {
        UserToken userToken = this.getUserToken();
        this.userTokenService.unBind(userToken);
        return RestResponse.ok();
    }
}

