/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.service.impl;

import com.mindskip.xzs.configuration.property.SystemConfig;
import com.mindskip.xzs.domain.User;
import com.mindskip.xzs.service.AuthenticationService;
import com.mindskip.xzs.service.UserService;
import com.mindskip.xzs.utility.RsaUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthenticationServiceImpl
implements AuthenticationService {
    private final UserService userService;
    private final SystemConfig systemConfig;

    @Autowired
    public AuthenticationServiceImpl(UserService userService, SystemConfig systemConfig) {
        this.userService = userService;
        this.systemConfig = systemConfig;
    }

    public boolean authUser(String username, String password) {
        User user = this.userService.getUserByUserName(username);
        return this.authUser(user, username, password);
    }

    public boolean authUser(User user, String username, String password) {
        if (user == null) {
            return false;
        }
        String encodePwd = user.getPassword();
        if (null == encodePwd || encodePwd.length() == 0) {
            return false;
        }
        String pwd = this.pwdDecode(encodePwd);
        return pwd.equals(password);
    }

    public String pwdEncode(String password) {
        return RsaUtil.rsaEncode((String)this.systemConfig.getPwdKey().getPublicKey(), (String)password);
    }

    public String pwdDecode(String encodePwd) {
        return RsaUtil.rsaDecode((String)this.systemConfig.getPwdKey().getPrivateKey(), (String)encodePwd);
    }
}

