/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.mindskip.xzs.domain.ExamPaper;
import com.mindskip.xzs.domain.ExamPaperAnswer;
import com.mindskip.xzs.domain.ExamPaperAnswerInfo;
import com.mindskip.xzs.domain.ExamPaperQuestionCustomerAnswer;
import com.mindskip.xzs.domain.Question;
import com.mindskip.xzs.domain.TaskExamCustomerAnswer;
import com.mindskip.xzs.domain.TextContent;
import com.mindskip.xzs.domain.User;
import com.mindskip.xzs.domain.enums.ExamPaperAnswerStatusEnum;
import com.mindskip.xzs.domain.enums.ExamPaperTypeEnum;
import com.mindskip.xzs.domain.enums.QuestionTypeEnum;
import com.mindskip.xzs.domain.exam.ExamPaperTitleItemObject;
import com.mindskip.xzs.domain.other.ExamPaperAnswerUpdate;
import com.mindskip.xzs.domain.other.KeyValue;
import com.mindskip.xzs.domain.task.TaskItemAnswerObject;
import com.mindskip.xzs.repository.BaseMapper;
import com.mindskip.xzs.repository.ExamPaperAnswerMapper;
import com.mindskip.xzs.repository.ExamPaperMapper;
import com.mindskip.xzs.repository.QuestionMapper;
import com.mindskip.xzs.repository.TaskExamCustomerAnswerMapper;
import com.mindskip.xzs.service.ExamPaperAnswerService;
import com.mindskip.xzs.service.ExamPaperQuestionCustomerAnswerService;
import com.mindskip.xzs.service.TextContentService;
import com.mindskip.xzs.service.impl.BaseServiceImpl;
import com.mindskip.xzs.service.impl.ExamPaperAnswerServiceImpl;
import com.mindskip.xzs.utility.DateTimeUtil;
import com.mindskip.xzs.utility.ExamUtil;
import com.mindskip.xzs.utility.JsonUtil;
import com.mindskip.xzs.viewmodel.admin.paper.ExamPaperAnswerPageRequestVM;
import com.mindskip.xzs.viewmodel.student.exam.ExamPaperSubmitItemVM;
import com.mindskip.xzs.viewmodel.student.exam.ExamPaperSubmitVM;
import com.mindskip.xzs.viewmodel.student.exampaper.ExamPaperAnswerPageVM;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExamPaperAnswerServiceImpl
extends BaseServiceImpl<ExamPaperAnswer>
implements ExamPaperAnswerService {
    private final ExamPaperAnswerMapper examPaperAnswerMapper;
    private final ExamPaperMapper examPaperMapper;
    private final TextContentService textContentService;
    private final QuestionMapper questionMapper;
    private final ExamPaperQuestionCustomerAnswerService examPaperQuestionCustomerAnswerService;
    private final TaskExamCustomerAnswerMapper taskExamCustomerAnswerMapper;

    @Autowired
    public ExamPaperAnswerServiceImpl(ExamPaperAnswerMapper examPaperAnswerMapper, ExamPaperMapper examPaperMapper, TextContentService textContentService, QuestionMapper questionMapper, ExamPaperQuestionCustomerAnswerService examPaperQuestionCustomerAnswerService, TaskExamCustomerAnswerMapper taskExamCustomerAnswerMapper) {
        super((BaseMapper)examPaperAnswerMapper);
        this.examPaperAnswerMapper = examPaperAnswerMapper;
        this.examPaperMapper = examPaperMapper;
        this.textContentService = textContentService;
        this.questionMapper = questionMapper;
        this.examPaperQuestionCustomerAnswerService = examPaperQuestionCustomerAnswerService;
        this.taskExamCustomerAnswerMapper = taskExamCustomerAnswerMapper;
    }

    public PageInfo<ExamPaperAnswer> studentPage(ExamPaperAnswerPageVM requestVM) {
        return PageHelper.startPage((int)requestVM.getPageIndex(), (int)requestVM.getPageSize(), (String)"id desc").doSelectPageInfo(() -> this.examPaperAnswerMapper.studentPage(requestVM));
    }

    public ExamPaperAnswerInfo calculateExamPaperAnswer(ExamPaperSubmitVM examPaperSubmitVM, User user) {
        ExamPaperAnswer examPaperAnswer;
        ExamPaperAnswerInfo examPaperAnswerInfo = new ExamPaperAnswerInfo();
        Date now = new Date();
        ExamPaper examPaper = (ExamPaper)this.examPaperMapper.selectByPrimaryKey(examPaperSubmitVM.getId());
        ExamPaperTypeEnum paperTypeEnum = ExamPaperTypeEnum.fromCode((Integer)examPaper.getPaperType());
        if (paperTypeEnum == ExamPaperTypeEnum.Task && null != (examPaperAnswer = this.examPaperAnswerMapper.getByPidUid(examPaperSubmitVM.getId(), user.getId()))) {
            return null;
        }
        String frameTextContent = ((TextContent)this.textContentService.selectById(examPaper.getFrameTextContentId())).getContent();
        List examPaperTitleItemObjects = JsonUtil.toJsonListObject((String)frameTextContent, ExamPaperTitleItemObject.class);
        List questionIds = examPaperTitleItemObjects.stream().flatMap(t -> t.getQuestionItems().stream().map(q -> q.getId())).collect(Collectors.toList());
        List questions = this.questionMapper.selectByIds(questionIds);
        List examPaperQuestionCustomerAnswers = examPaperTitleItemObjects.stream().flatMap(t -> t.getQuestionItems().stream().map(q -> {
            Question question = questions.stream().filter(tq -> tq.getId().equals(q.getId())).findFirst().get();
            ExamPaperSubmitItemVM customerQuestionAnswer = examPaperSubmitVM.getAnswerItems().stream().filter(tq -> tq.getQuestionId().equals(q.getId())).findFirst().orElse(null);
            return this.ExamPaperQuestionCustomerAnswerFromVM(question, customerQuestionAnswer, examPaper, q.getItemOrder(), user, now);
        })).collect(Collectors.toList());
        ExamPaperAnswer examPaperAnswer2 = this.ExamPaperAnswerFromVM(examPaperSubmitVM, examPaper, examPaperQuestionCustomerAnswers, user, now);
        examPaperAnswerInfo.setExamPaper(examPaper);
        examPaperAnswerInfo.setExamPaperAnswer(examPaperAnswer2);
        examPaperAnswerInfo.setExamPaperQuestionCustomerAnswers(examPaperQuestionCustomerAnswers);
        return examPaperAnswerInfo;
    }

    @Transactional
    public String judge(ExamPaperSubmitVM examPaperSubmitVM) {
        ExamPaperAnswer examPaperAnswer = (ExamPaperAnswer)this.examPaperAnswerMapper.selectByPrimaryKey(examPaperSubmitVM.getId());
        List judgeItems = examPaperSubmitVM.getAnswerItems().stream().filter(d -> d.getDoRight() == null).collect(Collectors.toList());
        ArrayList<ExamPaperAnswerUpdate> examPaperAnswerUpdates = new ArrayList<ExamPaperAnswerUpdate>(judgeItems.size());
        Integer customerScore = examPaperAnswer.getUserScore();
        Integer questionCorrect = examPaperAnswer.getQuestionCorrect();
        for (ExamPaperSubmitItemVM d2 : judgeItems) {
            ExamPaperAnswerUpdate examPaperAnswerUpdate = new ExamPaperAnswerUpdate();
            examPaperAnswerUpdate.setId(d2.getId());
            examPaperAnswerUpdate.setCustomerScore(ExamUtil.scoreFromVM((String)d2.getScore()));
            boolean doRight = examPaperAnswerUpdate.getCustomerScore().equals(ExamUtil.scoreFromVM((String)d2.getQuestionScore()));
            examPaperAnswerUpdate.setDoRight(Boolean.valueOf(doRight));
            examPaperAnswerUpdates.add(examPaperAnswerUpdate);
            customerScore = customerScore + examPaperAnswerUpdate.getCustomerScore();
            if (!examPaperAnswerUpdate.getDoRight().booleanValue()) continue;
            questionCorrect = questionCorrect + 1;
        }
        examPaperAnswer.setUserScore(customerScore);
        examPaperAnswer.setQuestionCorrect(questionCorrect);
        examPaperAnswer.setStatus(Integer.valueOf(ExamPaperAnswerStatusEnum.Complete.getCode()));
        this.examPaperAnswerMapper.updateByPrimaryKeySelective((Object)examPaperAnswer);
        this.examPaperQuestionCustomerAnswerService.updateScore(examPaperAnswerUpdates);
        ExamPaperTypeEnum examPaperTypeEnum = ExamPaperTypeEnum.fromCode((Integer)examPaperAnswer.getPaperType());
        switch (1.$SwitchMap$com$mindskip$xzs$domain$enums$ExamPaperTypeEnum[examPaperTypeEnum.ordinal()]) {
            case 1: {
                ExamPaper examPaper = (ExamPaper)this.examPaperMapper.selectByPrimaryKey(examPaperAnswer.getExamPaperId());
                Integer taskId = examPaper.getTaskExamId();
                Integer userId = examPaperAnswer.getCreateUser();
                TaskExamCustomerAnswer taskExamCustomerAnswer = this.taskExamCustomerAnswerMapper.getByTUid(taskId, userId);
                TextContent textContent = (TextContent)this.textContentService.selectById(taskExamCustomerAnswer.getTextContentId());
                List taskItemAnswerObjects = JsonUtil.toJsonListObject((String)textContent.getContent(), TaskItemAnswerObject.class);
                taskItemAnswerObjects.stream().filter(d -> d.getExamPaperAnswerId().equals(examPaperAnswer.getId())).findFirst().ifPresent(taskItemAnswerObject -> taskItemAnswerObject.setStatus(examPaperAnswer.getStatus()));
                this.textContentService.jsonConvertUpdate(textContent, taskItemAnswerObjects, null);
                this.textContentService.updateByIdFilter((Object)textContent);
                break;
            }
        }
        return ExamUtil.scoreToVM((Integer)customerScore);
    }

    public ExamPaperSubmitVM examPaperAnswerToVM(Integer id) {
        ExamPaperSubmitVM examPaperSubmitVM = new ExamPaperSubmitVM();
        ExamPaperAnswer examPaperAnswer = (ExamPaperAnswer)this.examPaperAnswerMapper.selectByPrimaryKey(id);
        examPaperSubmitVM.setId(examPaperAnswer.getId());
        examPaperSubmitVM.setDoTime(examPaperAnswer.getDoTime());
        examPaperSubmitVM.setScore(ExamUtil.scoreToVM((Integer)examPaperAnswer.getUserScore()));
        List examPaperQuestionCustomerAnswers = this.examPaperQuestionCustomerAnswerService.selectListByPaperAnswerId(examPaperAnswer.getId());
        List examPaperSubmitItemVMS = examPaperQuestionCustomerAnswers.stream().map(a -> this.examPaperQuestionCustomerAnswerService.examPaperQuestionCustomerAnswerToVM(a)).collect(Collectors.toList());
        examPaperSubmitVM.setAnswerItems(examPaperSubmitItemVMS);
        return examPaperSubmitVM;
    }

    public Integer selectAllCount() {
        return this.examPaperAnswerMapper.selectAllCount();
    }

    public List<Integer> selectMothCount() {
        Date startTime = DateTimeUtil.getMonthStartDay();
        Date endTime = DateTimeUtil.getMonthEndDay();
        List mouthCount = this.examPaperAnswerMapper.selectCountByDate(startTime, endTime);
        List mothStartToNowFormat = DateTimeUtil.MothStartToNowFormat();
        return mothStartToNowFormat.stream().map(md -> {
            KeyValue keyValue = mouthCount.stream().filter(kv -> kv.getName().equals(md)).findAny().orElse(null);
            return null == keyValue ? 0 : keyValue.getValue();
        }).collect(Collectors.toList());
    }

    private ExamPaperQuestionCustomerAnswer ExamPaperQuestionCustomerAnswerFromVM(Question question, ExamPaperSubmitItemVM customerQuestionAnswer, ExamPaper examPaper, Integer itemOrder, User user, Date now) {
        ExamPaperQuestionCustomerAnswer examPaperQuestionCustomerAnswer = new ExamPaperQuestionCustomerAnswer();
        examPaperQuestionCustomerAnswer.setQuestionId(question.getId());
        examPaperQuestionCustomerAnswer.setExamPaperId(examPaper.getId());
        examPaperQuestionCustomerAnswer.setQuestionScore(question.getScore());
        examPaperQuestionCustomerAnswer.setSubjectId(examPaper.getSubjectId());
        examPaperQuestionCustomerAnswer.setItemOrder(itemOrder);
        examPaperQuestionCustomerAnswer.setCreateTime(now);
        examPaperQuestionCustomerAnswer.setCreateUser(user.getId());
        examPaperQuestionCustomerAnswer.setQuestionType(question.getQuestionType());
        examPaperQuestionCustomerAnswer.setQuestionTextContentId(question.getInfoTextContentId());
        if (null == customerQuestionAnswer) {
            examPaperQuestionCustomerAnswer.setCustomerScore(Integer.valueOf(0));
        } else {
            this.setSpecialFromVM(examPaperQuestionCustomerAnswer, question, customerQuestionAnswer);
        }
        return examPaperQuestionCustomerAnswer;
    }

    private void setSpecialFromVM(ExamPaperQuestionCustomerAnswer examPaperQuestionCustomerAnswer, Question question, ExamPaperSubmitItemVM customerQuestionAnswer) {
        QuestionTypeEnum questionTypeEnum = QuestionTypeEnum.fromCode((Integer)examPaperQuestionCustomerAnswer.getQuestionType());
        switch (1.$SwitchMap$com$mindskip$xzs$domain$enums$QuestionTypeEnum[questionTypeEnum.ordinal()]) {
            case 1: 
            case 2: {
                examPaperQuestionCustomerAnswer.setAnswer(customerQuestionAnswer.getContent());
                examPaperQuestionCustomerAnswer.setDoRight(Boolean.valueOf(question.getCorrect().equals(customerQuestionAnswer.getContent())));
                examPaperQuestionCustomerAnswer.setCustomerScore(Integer.valueOf(examPaperQuestionCustomerAnswer.getDoRight() != false ? question.getScore() : 0));
                break;
            }
            case 3: {
                String customerAnswer = ExamUtil.contentToString((List)customerQuestionAnswer.getContentArray());
                examPaperQuestionCustomerAnswer.setAnswer(customerAnswer);
                examPaperQuestionCustomerAnswer.setDoRight(Boolean.valueOf(customerAnswer.equals(question.getCorrect())));
                examPaperQuestionCustomerAnswer.setCustomerScore(Integer.valueOf(examPaperQuestionCustomerAnswer.getDoRight() != false ? question.getScore() : 0));
                break;
            }
            case 4: {
                String correctAnswer = JsonUtil.toJsonStr((Object)customerQuestionAnswer.getContentArray());
                examPaperQuestionCustomerAnswer.setAnswer(correctAnswer);
                examPaperQuestionCustomerAnswer.setCustomerScore(Integer.valueOf(0));
                break;
            }
            default: {
                examPaperQuestionCustomerAnswer.setAnswer(customerQuestionAnswer.getContent());
                examPaperQuestionCustomerAnswer.setCustomerScore(Integer.valueOf(0));
            }
        }
    }

    private ExamPaperAnswer ExamPaperAnswerFromVM(ExamPaperSubmitVM examPaperSubmitVM, ExamPaper examPaper, List<ExamPaperQuestionCustomerAnswer> examPaperQuestionCustomerAnswers, User user, Date now) {
        Integer systemScore = examPaperQuestionCustomerAnswers.stream().mapToInt(a -> a.getCustomerScore()).sum();
        long questionCorrect = examPaperQuestionCustomerAnswers.stream().filter(a -> a.getCustomerScore().equals(a.getQuestionScore())).count();
        ExamPaperAnswer examPaperAnswer = new ExamPaperAnswer();
        examPaperAnswer.setPaperName(examPaper.getName());
        examPaperAnswer.setDoTime(examPaperSubmitVM.getDoTime());
        examPaperAnswer.setExamPaperId(examPaper.getId());
        examPaperAnswer.setCreateUser(user.getId());
        examPaperAnswer.setCreateTime(now);
        examPaperAnswer.setSubjectId(examPaper.getSubjectId());
        examPaperAnswer.setQuestionCount(examPaper.getQuestionCount());
        examPaperAnswer.setPaperScore(examPaper.getScore());
        examPaperAnswer.setPaperType(examPaper.getPaperType());
        examPaperAnswer.setSystemScore(systemScore);
        examPaperAnswer.setUserScore(systemScore);
        examPaperAnswer.setTaskExamId(examPaper.getTaskExamId());
        examPaperAnswer.setQuestionCorrect(Integer.valueOf((int)questionCorrect));
        boolean needJudge = examPaperQuestionCustomerAnswers.stream().anyMatch(d -> QuestionTypeEnum.needSaveTextContent((Integer)d.getQuestionType()));
        if (needJudge) {
            examPaperAnswer.setStatus(Integer.valueOf(ExamPaperAnswerStatusEnum.WaitJudge.getCode()));
        } else {
            examPaperAnswer.setStatus(Integer.valueOf(ExamPaperAnswerStatusEnum.Complete.getCode()));
        }
        return examPaperAnswer;
    }

    public PageInfo<ExamPaperAnswer> adminPage(ExamPaperAnswerPageRequestVM requestVM) {
        return PageHelper.startPage((int)requestVM.getPageIndex(), (int)requestVM.getPageSize(), (String)"id desc").doSelectPageInfo(() -> this.examPaperAnswerMapper.adminPage(requestVM));
    }
}

