/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.mindskip.xzs.domain.ExamPaperQuestionCustomerAnswer;
import com.mindskip.xzs.domain.TextContent;
import com.mindskip.xzs.domain.enums.QuestionTypeEnum;
import com.mindskip.xzs.domain.other.ExamPaperAnswerUpdate;
import com.mindskip.xzs.domain.other.KeyValue;
import com.mindskip.xzs.repository.BaseMapper;
import com.mindskip.xzs.repository.ExamPaperQuestionCustomerAnswerMapper;
import com.mindskip.xzs.service.ExamPaperQuestionCustomerAnswerService;
import com.mindskip.xzs.service.TextContentService;
import com.mindskip.xzs.service.impl.BaseServiceImpl;
import com.mindskip.xzs.service.impl.ExamPaperQuestionCustomerAnswerServiceImpl;
import com.mindskip.xzs.utility.DateTimeUtil;
import com.mindskip.xzs.utility.ExamUtil;
import com.mindskip.xzs.utility.JsonUtil;
import com.mindskip.xzs.viewmodel.student.exam.ExamPaperSubmitItemVM;
import com.mindskip.xzs.viewmodel.student.question.answer.QuestionPageStudentRequestVM;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExamPaperQuestionCustomerAnswerServiceImpl
extends BaseServiceImpl<ExamPaperQuestionCustomerAnswer>
implements ExamPaperQuestionCustomerAnswerService {
    private final ExamPaperQuestionCustomerAnswerMapper examPaperQuestionCustomerAnswerMapper;
    private final TextContentService textContentService;

    @Autowired
    public ExamPaperQuestionCustomerAnswerServiceImpl(ExamPaperQuestionCustomerAnswerMapper examPaperQuestionCustomerAnswerMapper, TextContentService textContentService) {
        super((BaseMapper)examPaperQuestionCustomerAnswerMapper);
        this.examPaperQuestionCustomerAnswerMapper = examPaperQuestionCustomerAnswerMapper;
        this.textContentService = textContentService;
    }

    public PageInfo<ExamPaperQuestionCustomerAnswer> studentPage(QuestionPageStudentRequestVM requestVM) {
        return PageHelper.startPage((int)requestVM.getPageIndex(), (int)requestVM.getPageSize(), (String)"id desc").doSelectPageInfo(() -> this.examPaperQuestionCustomerAnswerMapper.studentPage(requestVM));
    }

    public List<ExamPaperQuestionCustomerAnswer> selectListByPaperAnswerId(Integer id) {
        return this.examPaperQuestionCustomerAnswerMapper.selectListByPaperAnswerId(id);
    }

    public void insertList(List<ExamPaperQuestionCustomerAnswer> examPaperQuestionCustomerAnswers) {
        this.examPaperQuestionCustomerAnswerMapper.insertList(examPaperQuestionCustomerAnswers);
    }

    public ExamPaperSubmitItemVM examPaperQuestionCustomerAnswerToVM(ExamPaperQuestionCustomerAnswer qa) {
        ExamPaperSubmitItemVM examPaperSubmitItemVM = new ExamPaperSubmitItemVM();
        examPaperSubmitItemVM.setId(qa.getId());
        examPaperSubmitItemVM.setQuestionId(qa.getQuestionId());
        examPaperSubmitItemVM.setDoRight(qa.getDoRight());
        examPaperSubmitItemVM.setItemOrder(qa.getItemOrder());
        examPaperSubmitItemVM.setQuestionScore(ExamUtil.scoreToVM((Integer)qa.getQuestionScore()));
        examPaperSubmitItemVM.setScore(ExamUtil.scoreToVM((Integer)qa.getCustomerScore()));
        this.setSpecialToVM(examPaperSubmitItemVM, qa);
        return examPaperSubmitItemVM;
    }

    public Integer selectAllCount() {
        return this.examPaperQuestionCustomerAnswerMapper.selectAllCount();
    }

    public List<Integer> selectMothCount() {
        Date startTime = DateTimeUtil.getMonthStartDay();
        Date endTime = DateTimeUtil.getMonthEndDay();
        List mouthCount = this.examPaperQuestionCustomerAnswerMapper.selectCountByDate(startTime, endTime);
        List mothStartToNowFormat = DateTimeUtil.MothStartToNowFormat();
        return mothStartToNowFormat.stream().map(md -> {
            KeyValue keyValue = mouthCount.stream().filter(kv -> kv.getName().equals(md)).findAny().orElse(null);
            return null == keyValue ? 0 : keyValue.getValue();
        }).collect(Collectors.toList());
    }

    public int updateScore(List<ExamPaperAnswerUpdate> examPaperAnswerUpdates) {
        return this.examPaperQuestionCustomerAnswerMapper.updateScore(examPaperAnswerUpdates);
    }

    private void setSpecialToVM(ExamPaperSubmitItemVM examPaperSubmitItemVM, ExamPaperQuestionCustomerAnswer examPaperQuestionCustomerAnswer) {
        QuestionTypeEnum questionTypeEnum = QuestionTypeEnum.fromCode((Integer)examPaperQuestionCustomerAnswer.getQuestionType());
        switch (1.$SwitchMap$com$mindskip$xzs$domain$enums$QuestionTypeEnum[questionTypeEnum.ordinal()]) {
            case 1: {
                examPaperSubmitItemVM.setContent(examPaperQuestionCustomerAnswer.getAnswer());
                examPaperSubmitItemVM.setContentArray(ExamUtil.contentToArray((String)examPaperQuestionCustomerAnswer.getAnswer()));
                break;
            }
            case 2: {
                TextContent textContent = (TextContent)this.textContentService.selectById(examPaperQuestionCustomerAnswer.getTextContentId());
                List correctAnswer = JsonUtil.toJsonListObject((String)textContent.getContent(), String.class);
                examPaperSubmitItemVM.setContentArray(correctAnswer);
                break;
            }
            default: {
                if (QuestionTypeEnum.needSaveTextContent((Integer)examPaperQuestionCustomerAnswer.getQuestionType())) {
                    TextContent content = (TextContent)this.textContentService.selectById(examPaperQuestionCustomerAnswer.getTextContentId());
                    examPaperSubmitItemVM.setContent(content.getContent());
                    break;
                }
                examPaperSubmitItemVM.setContent(examPaperQuestionCustomerAnswer.getAnswer());
            }
        }
    }
}

