/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.mindskip.xzs.domain.Message;
import com.mindskip.xzs.domain.MessageUser;
import com.mindskip.xzs.repository.MessageMapper;
import com.mindskip.xzs.repository.MessageUserMapper;
import com.mindskip.xzs.service.MessageService;
import com.mindskip.xzs.viewmodel.admin.message.MessagePageRequestVM;
import com.mindskip.xzs.viewmodel.student.user.MessageRequestVM;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MessageServiceImpl
implements MessageService {
    private final MessageMapper messageMapper;
    private final MessageUserMapper messageUserMapper;

    @Autowired
    public MessageServiceImpl(MessageMapper messageMapper, MessageUserMapper messageUserMapper) {
        this.messageMapper = messageMapper;
        this.messageUserMapper = messageUserMapper;
    }

    public List<Message> selectMessageByIds(List<Integer> ids) {
        return this.messageMapper.selectByIds(ids);
    }

    public PageInfo<MessageUser> studentPage(MessageRequestVM requestVM) {
        return PageHelper.startPage((int)requestVM.getPageIndex(), (int)requestVM.getPageSize(), (String)"id desc").doSelectPageInfo(() -> this.messageUserMapper.studentPage(requestVM));
    }

    public PageInfo<Message> page(MessagePageRequestVM requestVM) {
        return PageHelper.startPage((int)requestVM.getPageIndex(), (int)requestVM.getPageSize(), (String)"id desc").doSelectPageInfo(() -> this.messageMapper.page(requestVM));
    }

    public List<MessageUser> selectByMessageIds(List<Integer> ids) {
        return this.messageUserMapper.selectByMessageIds(ids);
    }

    @Transactional
    public void sendMessage(Message message, List<MessageUser> messageUsers) {
        this.messageMapper.insertSelective((Object)message);
        messageUsers.forEach(d -> d.setMessageId(message.getId()));
        this.messageUserMapper.inserts(messageUsers);
    }

    @Transactional
    public void read(Integer id) {
        MessageUser messageUser = (MessageUser)this.messageUserMapper.selectByPrimaryKey(id);
        if (messageUser.getReaded().booleanValue()) {
            return;
        }
        messageUser.setReaded(Boolean.valueOf(true));
        messageUser.setReadTime(new Date());
        this.messageUserMapper.updateByPrimaryKeySelective((Object)messageUser);
        this.messageMapper.readAdd(messageUser.getMessageId());
    }

    public Integer unReadCount(Integer userId) {
        return this.messageUserMapper.unReadCount(userId);
    }

    public Message messageDetail(Integer id) {
        MessageUser messageUser = (MessageUser)this.messageUserMapper.selectByPrimaryKey(id);
        return (Message)this.messageMapper.selectByPrimaryKey(messageUser.getMessageId());
    }
}

