/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.service.impl;

import com.mindskip.xzs.domain.TextContent;
import com.mindskip.xzs.repository.BaseMapper;
import com.mindskip.xzs.repository.TextContentMapper;
import com.mindskip.xzs.service.TextContentService;
import com.mindskip.xzs.service.impl.BaseServiceImpl;
import com.mindskip.xzs.utility.JsonUtil;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TextContentServiceImpl
extends BaseServiceImpl<TextContent>
implements TextContentService {
    private final TextContentMapper textContentMapper;

    @Autowired
    public TextContentServiceImpl(TextContentMapper textContentMapper) {
        super((BaseMapper)textContentMapper);
        this.textContentMapper = textContentMapper;
    }

    public TextContent selectById(Integer id) {
        return (TextContent)super.selectById(id);
    }

    public int insertByFilter(TextContent record) {
        return super.insertByFilter((Object)record);
    }

    public int updateByIdFilter(TextContent record) {
        return super.updateByIdFilter((Object)record);
    }

    public <T, R> TextContent jsonConvertInsert(List<T> list, Date now, Function<? super T, ? extends R> mapper) {
        String frameTextContent = null;
        if (null == mapper) {
            frameTextContent = JsonUtil.toJsonStr(list);
        } else {
            List mapList = list.stream().map(mapper).collect(Collectors.toList());
            frameTextContent = JsonUtil.toJsonStr(mapList);
        }
        TextContent textContent = new TextContent(frameTextContent, now);
        return textContent;
    }

    public <T, R> TextContent jsonConvertUpdate(TextContent textContent, List<T> list, Function<? super T, ? extends R> mapper) {
        String frameTextContent = null;
        if (null == mapper) {
            frameTextContent = JsonUtil.toJsonStr(list);
        } else {
            List mapList = list.stream().map(mapper).collect(Collectors.toList());
            frameTextContent = JsonUtil.toJsonStr(mapList);
        }
        textContent.setContent(frameTextContent);
        return textContent;
    }
}

