/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.mindskip.xzs.domain.User;
import com.mindskip.xzs.domain.other.KeyValue;
import com.mindskip.xzs.event.OnRegistrationCompleteEvent;
import com.mindskip.xzs.exception.BusinessException;
import com.mindskip.xzs.repository.BaseMapper;
import com.mindskip.xzs.repository.UserMapper;
import com.mindskip.xzs.service.UserService;
import com.mindskip.xzs.service.impl.BaseServiceImpl;
import com.mindskip.xzs.viewmodel.admin.user.UserPageRequestVM;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserServiceImpl
extends BaseServiceImpl<User>
implements UserService {
    private final UserMapper userMapper;
    private final ApplicationEventPublisher eventPublisher;

    @Autowired
    public UserServiceImpl(UserMapper userMapper, ApplicationEventPublisher eventPublisher) {
        super((BaseMapper)userMapper);
        this.userMapper = userMapper;
        this.eventPublisher = eventPublisher;
    }

    public List<User> getUsers() {
        return this.userMapper.getAllUser();
    }

    public User getUserById(Integer id) {
        return this.userMapper.getUserById(id);
    }

    public User getUserByUserName(String username) {
        return this.userMapper.getUserByUserName(username);
    }

    public int insertByFilter(User record) {
        return super.insertByFilter((Object)record);
    }

    public int updateByIdFilter(User record) {
        return super.updateByIdFilter((Object)record);
    }

    public int updateById(User record) {
        return super.updateById((Object)record);
    }

    public User getUserByUserNamePwd(String username, String pwd) {
        return this.userMapper.getUserByUserNamePwd(username, pwd);
    }

    public User getUserByUuid(String uuid) {
        return this.userMapper.getUserByUuid(uuid);
    }

    public List<User> userPageList(String name, Integer pageIndex, Integer pageSize) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("name", name);
        map.put("offset", pageIndex * pageSize);
        map.put("limit", pageSize);
        return this.userMapper.userPageList(map);
    }

    public Integer userPageCount(String name) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("name", name);
        return this.userMapper.userPageCount(map);
    }

    public PageInfo<User> userPage(UserPageRequestVM requestVM) {
        return PageHelper.startPage((int)requestVM.getPageIndex(), (int)requestVM.getPageSize(), (String)"id desc").doSelectPageInfo(() -> this.userMapper.userPage(requestVM));
    }

    public void insertUser(User user) {
        this.userMapper.insertSelective((Object)user);
        this.eventPublisher.publishEvent((ApplicationEvent)new OnRegistrationCompleteEvent(user));
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void insertUsers(List<User> users) {
        this.userMapper.insertUsers(users);
        throw new BusinessException("test BusinessException roll back");
    }

    public void updateUser(User user) {
        this.userMapper.updateUser(user);
    }

    public void updateUsersAge(Integer age, List<Integer> ids) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("idslist", ids);
        map.put("age", age);
        this.userMapper.updateUsersAge(map);
    }

    public void deleteUserByIds(List<Integer> ids) {
        this.userMapper.deleteUsersByIds(ids);
    }

    public Integer selectAllCount() {
        return this.userMapper.selectAllCount();
    }

    public List<KeyValue> selectByUserName(String userName) {
        return this.userMapper.selectByUserName(userName);
    }

    public List<User> selectByIds(List<Integer> ids) {
        return this.userMapper.selectByIds(ids);
    }

    public User selectByWxOpenId(String wxOpenId) {
        return this.userMapper.selectByWxOpenId(wxOpenId);
    }

    @Transactional
    public void changePicture(User user, String imagePath) {
        User changePictureUser = new User();
        changePictureUser.setId(user.getId());
        changePictureUser.setImagePath(imagePath);
        this.userMapper.updateByPrimaryKeySelective((Object)changePictureUser);
    }
}

