/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.utility;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(JsonUtil.class);

    public static <T> String toJsonStr(T o) {
        try {
            return MAPPER.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T toJsonObject(String json, Class<T> valueType) {
        try {
            return (T)MAPPER.readValue(json, valueType);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> List<T> toJsonListObject(String json, Class<T> valueType) {
        try {
            JavaType getCollectionType = MAPPER.getTypeFactory().constructParametricType(List.class, new Class[]{valueType});
            List list = (List)MAPPER.readValue(json, getCollectionType);
            return list;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T toJsonObject(InputStream stream, Class<T> valueType) {
        try {
            Object object = MAPPER.readValue(stream, valueType);
            return (T)object;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

