/*
 * Decompiled with CFR 0.152.
 */
package com.mindskip.xzs.utility;

import com.mindskip.xzs.utility.JsonUtil;
import com.mindskip.xzs.utility.WxResponse;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxUtil {
    private static final Logger logger = LoggerFactory.getLogger(WxUtil.class);
    private static final String openIdUrl = "https://api.weixin.qq.com/sns/jscode2session?appid=%s&secret=%s&js_code=%s&grant_type=authorization_code";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getOpenId(String appId, String secret, String code) {
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            String requestUrl = String.format(openIdUrl, appId, secret, code);
            HttpGet httpGet = new HttpGet(requestUrl);
            HttpEntity responseEntity = httpClient.execute((HttpUriRequest)httpGet).getEntity();
            if (responseEntity == null) return null;
            String responseStr = EntityUtils.toString((HttpEntity)responseEntity);
            if (!responseStr.contains("openid")) return null;
            WxResponse wxResponse = (WxResponse)JsonUtil.toJsonObject((String)responseStr, WxResponse.class);
            String string = wxResponse.getOpenid();
            return string;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

